/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.event;

import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.event.EventUser;

public class EventImpl
implements Event {
    private final String type;
    private final long timestamp;
    private final String productVersion;
    private final EventUser user;
    private final Map<String, Object> fields;

    EventImpl(String type, long timestamp, String productVersion, EventUser user, Map<String, Object> fields) {
        this.type = type;
        this.timestamp = timestamp;
        this.productVersion = productVersion;
        this.user = user;
        this.fields = fields;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public EventUser getUser() {
        return this.user;
    }

    @Override
    public Map<String, Object> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        return this.timestamp == event.timestamp && Objects.equals(this.type, event.type) && Objects.equals(this.productVersion, event.productVersion) && Objects.equals(this.user, event.user) && Objects.equals(this.fields, event.fields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.timestamp, this.productVersion, this.user, this.fields);
    }

    public String toString() {
        return "EventImpl{type='" + this.type + "', timestamp=" + this.timestamp + ", productVersion='" + this.productVersion + "', user=" + this.user + ", fields=" + this.fields + "}";
    }
}

