/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.events;

import java.util.UUID;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.jetbrains.annotations.Nullable;

public class ComputeEventMetadata {
    private final EventUser eventUser;
    private final Type type;
    private final String jobClassName;
    @Nullable
    private final UUID jobId;
    private final String targetNode;
    private final String initiatorNode;
    @Nullable
    private final UUID taskId;
    @Nullable
    private final String tableName;
    @Nullable
    private final String clientAddress;

    ComputeEventMetadata(EventUser eventUser, Type type, String jobClassName, @Nullable UUID jobId, String targetNode, String initiatorNode, @Nullable UUID taskId, @Nullable String tableName, @Nullable String clientAddress) {
        this.eventUser = eventUser;
        this.type = type;
        this.jobClassName = jobClassName;
        this.jobId = jobId;
        this.targetNode = targetNode;
        this.initiatorNode = initiatorNode;
        this.taskId = taskId;
        this.tableName = tableName;
        this.clientAddress = clientAddress;
    }

    public static ComputeEventMetadataBuilder builder() {
        return new ComputeEventMetadataBuilder();
    }

    public static ComputeEventMetadataBuilder builder(Type type) {
        return new ComputeEventMetadataBuilder().type(type);
    }

    EventUser eventUser() {
        return this.eventUser;
    }

    Type type() {
        return this.type;
    }

    String jobClassName() {
        return this.jobClassName;
    }

    @Nullable
    UUID jobId() {
        return this.jobId;
    }

    String targetNode() {
        return this.targetNode;
    }

    String initiatorNode() {
        return this.initiatorNode;
    }

    @Nullable
    UUID taskId() {
        return this.taskId;
    }

    @Nullable
    String tableName() {
        return this.tableName;
    }

    @Nullable
    String clientAddress() {
        return this.clientAddress;
    }

    public static enum Type {
        SINGLE,
        BROADCAST,
        MAP_REDUCE,
        DATA_RECEIVER;

    }
}

