/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.Tuple;
import org.jetbrains.annotations.Nullable;

class ClientTuplesRequestBase {
    private final InternalTransaction tx;
    private final TableViewInternal table;
    private final List<Tuple> tuples;
    private final long resourceId;

    private ClientTuplesRequestBase(InternalTransaction tx, TableViewInternal table, List<Tuple> tuples, long resourceId) {
        this.tx = tx;
        this.table = table;
        this.tuples = tuples;
        this.resourceId = resourceId;
    }

    public InternalTransaction tx() {
        return this.tx;
    }

    public long resourceId() {
        return this.resourceId;
    }

    public TableViewInternal table() {
        return this.table;
    }

    public List<Tuple> tuples() {
        return this.tuples;
    }

    public static CompletableFuture<ClientTuplesRequestBase> readAsync(ClientMessageUnpacker in, IgniteTables tables, ClientResourceRegistry resources, TxManager txManager, boolean txReadOnly, @Nullable NotificationSender notificationSender, HybridTimestampTracker tsTracker, boolean keyOnly) {
        return ClientTuplesRequestBase.readAsync(in, tables, resources, txManager, txReadOnly, notificationSender, tsTracker, keyOnly, false);
    }

    public static CompletableFuture<ClientTuplesRequestBase> readAsync(ClientMessageUnpacker in, IgniteTables tables, ClientResourceRegistry resources, TxManager txManager, boolean txReadOnly, @Nullable NotificationSender notificationSender, HybridTimestampTracker tsTracker, boolean keyOnly, boolean readSecondTuple) {
        int tableId = in.unpackInt();
        long[] resIdHolder = new long[]{0L};
        InternalTransaction tx = ClientTableCommon.readOrStartImplicitTx(in, tsTracker, resources, txManager, txReadOnly, notificationSender, resIdHolder);
        int schemaId = in.unpackInt();
        int count = in.unpackInt();
        BitSet[] noValueSet = new BitSet[count];
        byte[][] tupleBytes = new byte[count][];
        for (int i = 0; i < count; ++i) {
            noValueSet[i] = in.unpackBitSet();
            tupleBytes[i] = in.readBinary();
        }
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ClientTableCommon.readSchema(schemaId, table).thenApply(schema -> {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>(count);
            for (int i = 0; i < count; ++i) {
                tuples.add(ClientTableCommon.readTuple(noValueSet[i], tupleBytes[i], keyOnly, schema));
            }
            return new ClientTuplesRequestBase(tx, (TableViewInternal)table, (List<Tuple>)tuples, resIdHolder[0]);
        }));
    }
}

