/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.executor;

import java.util.ArrayList;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import picocli.CommandLine;

public class RegistryCommandExecutor
implements Call<StringCallInput, Object> {
    private final Parser parser;
    private final CommandLine commandLine;

    public RegistryCommandExecutor(Parser parser, CommandLine commandLine) {
        this.parser = parser;
        this.commandLine = commandLine;
    }

    @Override
    public CallOutput<Object> execute(StringCallInput input) {
        try {
            String[] args = new ArrayList(this.parser.parse(input.getString(), 0, Parser.ParseContext.SPLIT_LINE).words()).toArray(new String[0]);
            this.commandLine.execute(args);
            return DefaultCallOutput.empty();
        }
        catch (Exception e) {
            return DefaultCallOutput.failure(e);
        }
    }

    public void cleanUp() {
        this.commandLine.clearExecutionResults();
    }

    public boolean hasCommand(String line) {
        ParsedLine pl = this.parser.parse(line, 0, Parser.ParseContext.SPLIT_LINE);
        return !pl.words().isEmpty() && this.commandLine.getSubcommands().containsKey(this.parser.getCommand((String)pl.words().get(0)));
    }
}

