/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer.filter;

import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.repl.completer.filter.CompleterFilter;

@Singleton
public class DynamicCompleterFilter
implements CompleterFilter {
    private final Session session;

    public DynamicCompleterFilter(Session session) {
        this.session = session;
    }

    private static boolean optionTyped(String[] words) {
        String lastWord = words[words.length - 1];
        return lastWord.startsWith("-");
    }

    @Override
    public String[] filter(String[] words, String[] candidates) {
        if (DynamicCompleterFilter.optionTyped(words)) {
            return candidates;
        }
        List notOptionsCandidates = Arrays.stream(candidates).filter(candidate -> !candidate.startsWith("-")).collect(Collectors.toList());
        if (!notOptionsCandidates.isEmpty()) {
            return (String[])notOptionsCandidates.toArray(String[]::new);
        }
        return (String[])Arrays.stream(candidates).filter(candidate -> this.filterClusterUrl(words, (String)candidate)).filter(this::filterCommonOptions).toArray(String[]::new);
    }

    private boolean filterCommonOptions(String candidate) {
        return !"--help".equals(candidate) && !"-h".equals(candidate) && !"--profile".equals(candidate) && !"-v".equals(candidate) && !"--verbose".equals(candidate);
    }

    private boolean filterClusterUrl(String[] words, String candidate) {
        return DynamicCompleterFilter.optionTyped(words) || this.session.info() == null || !candidate.equals("--url");
    }
}

