/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"groups", "seq"}, onlyOneOf=true, optional=true)
public class CacheListCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(example="regexPattern")
    private String regex;
    @Argument(description="print all configuration parameters for each cache", optional=true)
    private boolean config;
    @Positional
    @Argument(optional=true, example="nodeId")
    private UUID nodeId;
    @Argument(description="print configuration parameters per line. This option has effect only when used with --config and without [--groups|--seq]", example="multi-line", optional=true)
    private String outputFormat;
    @Argument(description="print information about groups")
    private boolean groups;
    @Argument(description="print information about sequences")
    private boolean seq;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.regex);
        out.writeBoolean(this.config);
        U.writeUuid(out, this.nodeId);
        U.writeString(out, this.outputFormat);
        out.writeBoolean(this.groups);
        out.writeBoolean(this.seq);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.regex = U.readString(in);
        this.config = in.readBoolean();
        this.nodeId = U.readUuid(in);
        this.outputFormat = U.readString(in);
        this.groups = in.readBoolean();
        this.seq = in.readBoolean();
    }

    public String regex() {
        return this.regex;
    }

    public void regex(String regex) {
        this.regex = regex;
    }

    public boolean groups() {
        return this.groups;
    }

    public void groups(boolean groups) {
        this.groups = groups;
    }

    public boolean seq() {
        return this.seq;
    }

    public void seq(boolean seq) {
        this.seq = seq;
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public void outputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean config() {
        return this.config;
    }

    public void config(boolean config) {
        this.config = config;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }
}

