/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import java.util.Objects;
import org.apache.ignite.internal.ClassSet;
import org.apache.ignite.lang.IgnitePredicate;

public class IgniteMarshallerClassFilter
implements IgnitePredicate<String> {
    private static final long serialVersionUID = 0L;
    private final transient ClassSet whiteList;
    private final transient ClassSet blackList;

    public IgniteMarshallerClassFilter(ClassSet whiteList, ClassSet blackList) {
        this.whiteList = whiteList;
        this.blackList = blackList;
    }

    @Override
    public boolean apply(String s) {
        if ((this.blackList != null || this.whiteList != null) && s.charAt(0) == '[') {
            return true;
        }
        return !(this.blackList != null && this.blackList.contains(s) || this.whiteList != null && !this.whiteList.contains(s));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteMarshallerClassFilter)) {
            return false;
        }
        IgniteMarshallerClassFilter other = (IgniteMarshallerClassFilter)o;
        return Objects.equals(this.whiteList, other.whiteList) && Objects.equals(this.blackList, other.blackList);
    }

    public int hashCode() {
        return Objects.hash(this.whiteList, this.blackList);
    }
}

