/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SnapshotCreateCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(description="Snapshot name. In the case of incremental snapshot (--incremental) full snapshot name must be provided")
    private String snapshotName;
    @Argument(example="path", optional=true, description="Path to the directory where the snapshot will be saved. If not specified, the default configured snapshot directory will be used")
    private String dest;
    @Argument(optional=true, description="Run the operation synchronously, the command will wait for the entire operation to complete. Otherwise, it will be performed in the background, and the command will immediately return control")
    private boolean sync;
    @Argument(optional=true, description="Create an incremental snapshot for previously created full snapshot. Full snapshot must be accessible via --dest and snapshot_name")
    private boolean incremental;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.snapshotName);
        U.writeString(out, this.dest);
        out.writeBoolean(this.sync);
        out.writeBoolean(this.incremental);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotName = U.readString(in);
        this.dest = U.readString(in);
        this.sync = in.readBoolean();
        this.incremental = in.readBoolean();
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public void snapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String dest() {
        return this.dest;
    }

    public void dest(String dest) {
        this.dest = dest;
    }

    public boolean sync() {
        return this.sync;
    }

    public void sync(boolean sync) {
        this.sync = sync;
    }

    public boolean incremental() {
        return this.incremental;
    }

    public void incremental(boolean incremental) {
        this.incremental = incremental;
    }
}

