/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkProbePointWriter;
import org.yardstickframework.BenchmarkUtils;

public class BenchmarkProbePointCsvWriter
implements BenchmarkProbePointWriter {
    private static final String DUPLICATE_TO_OUTPUT = "BENCHMARK_WRITER_DUPLICATE_TO_OUTPUT";
    private static final boolean DEFAULT_DUPLICATE_TO_OUTPUT = false;
    public static final String META_INFO_SEPARATOR = ",";
    public static final String DRV_NAMES_PREFIX = "@@";
    public static final String META_INFO_PREFIX = "**";
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private PrintWriter writer;
    private BenchmarkConfiguration cfg;
    private BenchmarkDriver drv;
    private long startTime;
    private boolean dupToOutput;
    private File outPath;

    @Override
    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg, long startTime) {
        String hostName;
        this.cfg = cfg;
        this.drv = drv;
        this.startTime = startTime;
        this.dupToOutput = this.duplicateToOutput(cfg);
        String path = cfg.outputFolder();
        File folder = null;
        if (path != null && !(folder = new File(path)).exists() && !folder.mkdirs()) {
            throw new IllegalStateException("Can not create folder: " + folder.getAbsolutePath());
        }
        String desc = drv.description() == null ? "" : drv.description();
        desc = desc.replaceAll("-+", "-").replaceAll(",|\\\\|/|\\||%|:|<|>|\\*|\\?|\"|\\s", "-");
        desc = desc.charAt(0) == '-' ? desc : '-' + desc;
        String subFolderName = FORMAT.format(new Date(startTime));
        String string = hostName = cfg.hostName().isEmpty() ? "" : '-' + cfg.hostName();
        if (cfg.driverNames().size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String drvName : cfg.driverNames()) {
                sb.append(drvName.split(":")[0].trim()).append('-');
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 1, sb.length());
            }
            subFolderName = subFolderName + '-' + sb.toString();
            subFolderName = subFolderName + File.separator + desc.substring(1) + hostName;
        } else {
            subFolderName = subFolderName + desc + hostName;
        }
        subFolderName = BenchmarkUtils.fixFolderName(subFolderName);
        File file = this.outPath = folder == null ? new File(subFolderName) : new File(folder, subFolderName);
        if (!this.outPath.exists() && !this.outPath.mkdirs()) {
            throw new IllegalStateException("Can not create folder: " + this.outPath.getAbsolutePath());
        }
    }

    @Override
    public void writePoints(BenchmarkProbe probe, Collection<BenchmarkProbePoint> points) throws Exception {
        if (this.writer == null) {
            File outPath0;
            String fileName = probe.getClass().getSimpleName() + ".csv";
            File f = this.outPath == null ? new File(fileName) : new File(this.outPath, fileName);
            this.writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            String parent = this.cfg.driverNames().size() > 1 ? ((outPath0 = this.outPath.getParentFile()).getParent() == null ? this.outPath.getPath() : outPath0.getPath()) : (this.outPath.getParent() == null ? this.outPath.getPath() : this.outPath.getParent());
            BenchmarkUtils.println(this.cfg, probe.getClass().getSimpleName() + " results will be saved to: " + parent);
            this.println("--Probe dump file for probe: " + probe + " (" + probe.getClass() + ")");
            this.println("--Created " + new Date(this.startTime));
            this.println("--Benchmark config: " + this.removeUnwantedChars(this.cfg.toString()));
            this.println("--Description: " + this.removeUnwantedChars(this.drv.description() == null ? "" : this.drv.description()));
            this.println(DRV_NAMES_PREFIX + this.cfg.driverNames().toString().replaceAll("\\[", "").replaceAll("]", ""));
            if (probe.metaInfo() != null && !probe.metaInfo().isEmpty()) {
                this.print(META_INFO_PREFIX);
                int i = 0;
                for (String metaInfo : probe.metaInfo()) {
                    this.print("\"" + metaInfo + "\"" + (++i == probe.metaInfo().size() ? "" : META_INFO_SEPARATOR));
                }
                if (i != 0) {
                    this.println("");
                }
            }
        }
        for (BenchmarkProbePoint pt : points) {
            this.print(String.valueOf(pt.time()));
            this.print(META_INFO_SEPARATOR);
            double[] vals = pt.values();
            for (int i = 0; i < vals.length; ++i) {
                this.print(String.format(Locale.US, "%.2f", vals[i]));
                if (i == vals.length - 1) continue;
                this.print(META_INFO_SEPARATOR);
            }
            this.println("");
        }
        this.writer.flush();
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void print(String s) {
        this.writer.print(s);
        if (this.dupToOutput) {
            this.cfg.output().print(s);
        }
    }

    private void println(String s) {
        this.writer.println(s);
        if (this.dupToOutput) {
            BenchmarkUtils.println(this.cfg, s);
        }
    }

    private String removeUnwantedChars(String val) {
        return val.replaceAll("\n|\t|\r|\f", "");
    }

    private boolean duplicateToOutput(BenchmarkConfiguration cfg) {
        try {
            return Boolean.parseBoolean(cfg.customProperties().get(DUPLICATE_TO_OUTPUT));
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return false;
        }
    }
}

