/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.IBANCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IBANCheckDigitTest
extends AbstractCheckDigitTest {
    IBANCheckDigitTest() {
        this.checkDigitLth = 2;
    }

    @Override
    protected String checkDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return "";
        }
        return code.substring(2, 4);
    }

    @Override
    protected String[] createInvalidCodes(String[] codes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String code2 : codes) {
            String code = this.removeCheckDigit(code2);
            String check = this.checkDigit(code2);
            for (int j = 2; j <= 98; ++j) {
                String curr;
                String string = curr = j > 9 ? "" + j : "0" + j;
                if (curr.equals(check)) continue;
                list.add(code.substring(0, 2) + curr + code.substring(4));
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    protected String removeCheckDigit(String code) {
        return code.substring(0, 2) + "00" + code.substring(4);
    }

    @BeforeEach
    protected void setUp() {
        this.routine = IBANCheckDigit.IBAN_CHECK_DIGIT;
        this.valid = new String[]{"AD1200012030200359100100", "AE070331234567890123456", "AL47212110090000000235698741", "AT611904300234573201", "AZ21NABZ00000000137010001944", "BA391290079401028494", "BE62510007547061", "BE68539007547034", "BG80BNBG96611020345678", "BH67BMAG00001299123456", "BI4210000100010000332045181", "BR1800000000141455123924100C2", "BY13NBRB3600900000002Z00AB00", "CH3900700115201849173", "CH9300762011623852957", "CR05015202001026284066", "CY17002001280000001200527600", "CZ6508000000192000145399", "DE89370400440532013000", "DJ2110002010010409943020008", "DK5000400440116243", "DO28BAGR00000001212453611324", "EE382200221020145685", "ES8023100001180000012345", "FI2112345600000785", "FO6264600001631634", "FR1420041010050500013M02606", "GB29NWBK60161331926819", "GI75NWBK000000007099453", "GL8964710001000206", "GR1601101250000000012300695", "GT82TRAJ01020000001210029690", "HR1210010051863000160", "HU42117730161111101800000000", "IE29AIBK93115212345678", "IL620108000000099999999", "IQ98NBIQ850123456789012", "IS140159260076545510730339", "IT60X0542811101000000123456", "JO94CBJO0010000000000131000302", "KW81CBKU0000000000001234560101", "KZ86125KZT5004100100", "LB62099900000001001901229114", "LC55HEMM000100010012001200023015", "LI21088100002324013AA", "LT121000011101001000", "LU280019400644750000", "LV80BANK0000435195001", "MC5811222000010123456789030", "MD24AG000225100013104168", "ME25505000012345678951", "MK07250120000058984", "MR1300020001010000123456753", "MT84MALT011000012345MTLCAST001S", "MU17BOMM0101101030300200000MUR", "NL39RABO0300065264", "NL91ABNA0417164300", "NO9386011117947", "PK36SCBL0000001123456702", "PL27114020040000300201355387", "PL60102010260000042270201111", "PS92PALS000000000400123456702", "PT50000201231234567890154", "QA58DOHB00001234567890ABCDEFG", "RO49AAAA1B31007593840000", "RS35260005601001611379", "RU0204452560040702810412345678901", "SA0380000000608010167519", "SC18SSCB11010000000000001497USD", "SD8811123456789012", "SE3550000000054910000003", "SD2129010501234001", "SI56191000000123438", "SK3112000000198742637541", "SM86U0322509800000000270100", "ST68000100010051845310112", "SV62CENR00000000000000700025", "TL380080012345678910157", "TN5910006035183598478831", "TR330006100519786457841326", "UA213223130000026007233566001", "VA59001123000012345678", "VG96VPVG0000012345678901", "XK051212012345678906", "AA0200000000053", "AA9700000000089", "AA9800000000071", "ZZ02ZZZZZZZZZZZZZZZZZZZZZZZZZ04", "ZZ97ZZZZZZZZZZZZZZZZZZZZZZZZZ40", "ZZ98ZZZZZZZZZZZZZZZZZZZZZZZZZ22"};
        this.invalid = new String[]{"510007+47061BE63", "IE01AIBK93118702569045", "AA0000000000089", "AA9900000000053"};
        this.zeroSum = null;
        this.missingMessage = "Invalid Code length=0";
    }

    @Test
    void testOther() throws Exception {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("IBANtests.txt"), "ASCII"));){
            String line;
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                if (line.startsWith("-")) {
                    line = line.substring(1);
                    Assertions.assertFalse((boolean)this.routine.isValid(line.replace(" ", "")), (String)line);
                    continue;
                }
                Assertions.assertTrue((boolean)this.routine.isValid(line.replace(" ", "")), (String)line);
            }
        }
    }

    @Override
    @Test
    void testZeroSum() {
    }
}

