/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class ParetoDistribution
extends AbstractContinuousDistribution {
    private static final double MIN_SHAPE_FOR_VARIANCE = 2.0;
    private final double scale;
    private final double shape;
    private final DoubleUnaryOperator pdf;
    private final DoubleUnaryOperator logpdf;

    private ParetoDistribution(double scale, double shape) {
        this.scale = scale;
        this.shape = shape;
        double shapeByScalePowShape = shape * Math.pow(scale, shape);
        double logShapePlusShapeByLogScale = Math.log(shape) + Math.log(scale) * shape;
        if (shapeByScalePowShape < Double.POSITIVE_INFINITY && shapeByScalePowShape >= Double.MIN_NORMAL) {
            this.pdf = x -> shapeByScalePowShape / Math.pow(x, shape + 1.0);
            this.logpdf = x -> logShapePlusShapeByLogScale - Math.log(x) * (shape + 1.0);
        } else if (Double.isFinite(logShapePlusShapeByLogScale)) {
            this.logpdf = x -> logShapePlusShapeByLogScale - Math.log(x) * (shape + 1.0);
            this.pdf = x -> Math.exp(this.logpdf.applyAsDouble(x));
        } else {
            this.logpdf = x -> x > scale ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            this.pdf = x -> x > scale ? 0.0 : Double.POSITIVE_INFINITY;
        }
    }

    public static ParetoDistribution of(double scale, double shape) {
        if (scale <= 0.0 || scale == Double.POSITIVE_INFINITY) {
            throw new DistributionException("Number %s is not greater than 0 and finite", scale);
        }
        if (shape <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", shape);
        }
        return new ParetoDistribution(scale, shape);
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double x) {
        if (x < this.scale) {
            return 0.0;
        }
        return this.pdf.applyAsDouble(x);
    }

    @Override
    public double logDensity(double x) {
        if (x < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.logpdf.applyAsDouble(x);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.scale) {
            return 0.0;
        }
        return -Math.expm1(this.shape * Math.log(this.scale / x));
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= this.scale) {
            return 1.0;
        }
        return Math.pow(this.scale / x, this.shape);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return this.getSupportLowerBound();
        }
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        return this.scale / Math.exp(Math.log1p(-p) / this.shape);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return this.getSupportLowerBound();
        }
        if (p == 0.0) {
            return this.getSupportUpperBound();
        }
        return this.scale / Math.pow(p, 1.0 / this.shape);
    }

    @Override
    public double getMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.shape == Double.POSITIVE_INFINITY) {
            return this.scale;
        }
        return this.scale * (this.shape / (this.shape - 1.0));
    }

    @Override
    public double getVariance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.shape == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double s = this.shape - 1.0;
        double z = this.shape / s / s / (this.shape - 2.0);
        return z < 1.0 ? z * this.scale * this.scale : this.scale * this.scale * z;
    }

    @Override
    public double getSupportLowerBound() {
        return this.getScale();
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)InverseTransformParetoSampler.of((UniformRandomProvider)rng, (double)this.scale, (double)this.shape)).sample();
    }
}

