/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.summary;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math4.legacy.stat.descriptive.WeightedEvaluation;

public class Product
extends AbstractStorelessUnivariateStatistic
implements WeightedEvaluation {
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = 1.0;
    }

    public Product(Product original) throws NullArgumentException {
        Product.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value *= d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 1.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length, (boolean)true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= values[i];
            }
        }
        return product;
    }

    @Override
    public double evaluate(double[] values, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (double[])weights, (int)begin, (int)length, (boolean)true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= JdkMath.pow((double)values[i], (double)weights[i]);
            }
        }
        return product;
    }

    @Override
    public double evaluate(double[] values, double[] weights) throws MathIllegalArgumentException {
        return this.evaluate(values, weights, 0, values.length);
    }

    @Override
    public Product copy() {
        Product result = new Product();
        Product.copy(this, result);
        return result;
    }

    public static void copy(Product source, Product dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        dest.n = source.n;
        dest.value = source.value;
    }
}

