/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.rank;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.stat.descriptive.rank.PivotingStrategy;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public class RandomPivotingStrategy
implements PivotingStrategy {
    private final RandomSource randomSource;
    private transient RestorableUniformRandomProvider random;

    public RandomPivotingStrategy(RandomSource randomSource, long seed) {
        this.randomSource = randomSource;
        this.random = randomSource.create((Object)seed, new Object[0]);
    }

    @Override
    public int pivotIndex(double[] work, int begin, int end) {
        MathArrays.verifyValues((double[])work, (int)begin, (int)(end - begin));
        return begin + this.random.nextInt(end - begin - 1);
    }
}

