/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.SecondaryEquations;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.events.EventState;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math3.ode.nonstiff.LutherIntegrator;
import org.apache.commons.math3.ode.sampling.DummyStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.junit.Assert;
import org.junit.Test;

public class EventStateTest {
    @Test
    public void closeEvents() throws MaxCountExceededException, NoBracketingException {
        double r1 = 90.0;
        double r2 = 135.0;
        double gap = 45.0;
        double tolerance = 0.1;
        EventState es = new EventState((EventHandler)new CloseEventsGenerator(90.0, 135.0), 67.5, 0.1, 100, (UnivariateSolver)new BrentSolver(0.1));
        es.setExpandable(new ExpandableStatefulODE(new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 0;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
            }
        }));
        DummyStepInterpolator interpolator = new DummyStepInterpolator(new double[0], new double[0], true);
        interpolator.storeTime(-22.5);
        interpolator.shift();
        interpolator.storeTime(22.5);
        es.reinitializeBegin((StepInterpolator)interpolator);
        interpolator.shift();
        interpolator.storeTime(67.5);
        Assert.assertFalse((boolean)es.evaluateStep((StepInterpolator)interpolator));
        interpolator.shift();
        interpolator.storeTime(112.5);
        Assert.assertTrue((boolean)es.evaluateStep((StepInterpolator)interpolator));
        Assert.assertEquals((double)90.0, (double)es.getEventTime(), (double)0.1);
        es.stepAccepted(es.getEventTime(), new double[0]);
        interpolator.shift();
        interpolator.storeTime(153.0);
        Assert.assertTrue((boolean)es.evaluateStep((StepInterpolator)interpolator));
        Assert.assertEquals((double)135.0, (double)es.getEventTime(), (double)0.1);
    }

    @Test
    public void testIssue695() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        FirstOrderDifferentialEquations equation = new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                yDot[0] = 1.0;
            }
        };
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 1000.0, 1.0E-14, 1.0E-14);
        integrator.addEventHandler((EventHandler)new ResettingEvent(10.99), 0.1, 1.0E-9, 1000);
        integrator.addEventHandler((EventHandler)new ResettingEvent(11.01), 0.1, 1.0E-9, 1000);
        integrator.setInitialStepSize(3.0);
        double target = 30.0;
        double[] y = new double[1];
        double tEnd = integrator.integrate(equation, 0.0, y, target, y);
        Assert.assertEquals((double)target, (double)tEnd, (double)1.0E-10);
        Assert.assertEquals((double)32.0, (double)y[0], (double)1.0E-10);
    }

    @Test
    public void testIssue965() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        ExpandableStatefulODE equation = new ExpandableStatefulODE(new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                yDot[0] = 2.0;
            }
        });
        equation.setTime(0.0);
        equation.setPrimaryState(new double[1]);
        equation.addSecondaryEquations(new SecondaryEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary, double[] secondaryDot) {
                secondaryDot[0] = -3.0;
            }
        });
        int index = equation.getSecondaryMappers()[0].getFirstIndex();
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 1000.0, 1.0E-14, 1.0E-14);
        integrator.addEventHandler((EventHandler)new SecondaryStateEvent(index, -3.0), 0.1, 1.0E-9, 1000);
        integrator.setInitialStepSize(3.0);
        integrator.integrate(equation, 30.0);
        Assert.assertEquals((double)1.0, (double)equation.getTime(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)equation.getPrimaryState()[0], (double)1.0E-10);
        Assert.assertEquals((double)-3.0, (double)equation.getSecondaryState(0)[0], (double)1.0E-10);
    }

    @Test
    public void testEventsCloserThanThreshold() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        FirstOrderDifferentialEquations equation = new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                yDot[0] = 1.0;
            }
        };
        LutherIntegrator integrator = new LutherIntegrator(20.0);
        CloseEventsGenerator eventsGenerator = new CloseEventsGenerator(8.9921875, 9.0078125);
        integrator.addEventHandler((EventHandler)eventsGenerator, 1.0, 0.02, 1000);
        double[] y = new double[1];
        double tEnd = integrator.integrate(equation, 0.0, y, 100.0, y);
        Assert.assertEquals((long)2L, (long)eventsGenerator.getCount());
        Assert.assertEquals((double)9.0078125, (double)tEnd, (double)0.03125);
    }

    private class CloseEventsGenerator
    implements EventHandler {
        final double r1;
        final double r2;
        int count;

        public CloseEventsGenerator(double r1, double r2) {
            this.r1 = r1;
            this.r2 = r2;
            this.count = 0;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public void resetState(double t, double[] y) {
        }

        public double g(double t, double[] y) {
            return (t - this.r1) * (this.r2 - t);
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            return ++this.count < 2 ? EventHandler.Action.CONTINUE : EventHandler.Action.STOP;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class SecondaryStateEvent
    implements EventHandler {
        private int index;
        private final double target;

        public SecondaryStateEvent(int index, double target) {
            this.index = index;
            this.target = target;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return y[this.index] - this.target;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            return EventHandler.Action.STOP;
        }

        public void resetState(double t, double[] y) {
        }
    }

    private static class ResettingEvent
    implements EventHandler {
        private static double lastTriggerTime = Double.NEGATIVE_INFINITY;
        private final double tEvent;

        public ResettingEvent(double tEvent) {
            this.tEvent = tEvent;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            Assert.assertTrue((String)("going backard in time! (" + t + " < " + lastTriggerTime + ")"), (t >= lastTriggerTime ? 1 : 0) != 0);
            return t - this.tEvent;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            lastTriggerTime = t;
            return EventHandler.Action.RESET_STATE;
        }

        public void resetState(double t, double[] y) {
            y[0] = y[0] + 1.0;
        }
    }
}

