/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.Random;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.ContinuousOutputFieldModel;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import org.apache.commons.math3.ode.TestFieldProblem3;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54FieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.apache.commons.math3.ode.sampling.DummyFieldStepInterpolator;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.Decimal64Field;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousOutputFieldModelTest {
    @Test
    public void testBoundaries() {
        this.doTestBoundaries((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestBoundaries(Field<T> field) {
        TestFieldProblem3<RealFieldElement> pb = new TestFieldProblem3<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        DormandPrince54FieldIntegrator integ = new DormandPrince54FieldIntegrator(field, minStep, maxStep, 1.0E-8, 1.0E-8);
        integ.addStepHandler((FieldStepHandler)new ContinuousOutputFieldModel());
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        ContinuousOutputFieldModel cm = (ContinuousOutputFieldModel)integ.getStepHandlers().iterator().next();
        cm.getInterpolatedState((RealFieldElement)((RealFieldElement)pb.getInitialState().getTime().multiply(2)).subtract(pb.getFinalTime()));
        cm.getInterpolatedState((RealFieldElement)((RealFieldElement)pb.getFinalTime().multiply(2)).subtract((Object)pb.getInitialState().getTime()));
        cm.getInterpolatedState((RealFieldElement)((RealFieldElement)pb.getInitialState().getTime().add(pb.getFinalTime())).multiply(0.5));
    }

    @Test
    public void testRandomAccess() {
        this.doTestRandomAccess((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestRandomAccess(Field<T> field) {
        TestFieldProblem3<RealFieldElement> pb = new TestFieldProblem3<RealFieldElement>(field, (RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        double minStep = 0.0;
        double maxStep = ((RealFieldElement)pb.getFinalTime().subtract((Object)pb.getInitialState().getTime())).getReal();
        DormandPrince54FieldIntegrator integ = new DormandPrince54FieldIntegrator(field, minStep, maxStep, 1.0E-8, 1.0E-8);
        ContinuousOutputFieldModel cm = new ContinuousOutputFieldModel();
        integ.addStepHandler((FieldStepHandler)cm);
        integ.integrate(new FieldExpandableODE(pb), pb.getInitialState(), pb.getFinalTime());
        Random random = new Random(347588535632L);
        RealFieldElement maxError = (RealFieldElement)field.getZero();
        RealFieldElement maxErrorDot = (RealFieldElement)field.getZero();
        for (int i = 0; i < 1000; ++i) {
            double r = random.nextDouble();
            RealFieldElement time = (RealFieldElement)((RealFieldElement)pb.getInitialState().getTime().multiply(r)).add(pb.getFinalTime().multiply(1.0 - r));
            FieldODEStateAndDerivative interpolated = cm.getInterpolatedState(time);
            RealFieldElement[] theoreticalY = pb.computeTheoreticalState(time);
            RealFieldElement[] theoreticalYDot = pb.doComputeDerivatives(time, theoreticalY);
            RealFieldElement dx = (RealFieldElement)interpolated.getState()[0].subtract((Object)theoreticalY[0]);
            RealFieldElement dy = (RealFieldElement)interpolated.getState()[1].subtract((Object)theoreticalY[1]);
            RealFieldElement error = (RealFieldElement)((RealFieldElement)dx.multiply((Object)dx)).add(dy.multiply((Object)dy));
            maxError = MathUtils.max((RealFieldElement)maxError, (RealFieldElement)error);
            RealFieldElement dxDot = (RealFieldElement)interpolated.getDerivative()[0].subtract((Object)theoreticalYDot[0]);
            RealFieldElement dyDot = (RealFieldElement)interpolated.getDerivative()[1].subtract((Object)theoreticalYDot[1]);
            RealFieldElement errorDot = (RealFieldElement)((RealFieldElement)dxDot.multiply((Object)dxDot)).add(dyDot.multiply((Object)dyDot));
            maxErrorDot = MathUtils.max((RealFieldElement)maxErrorDot, (RealFieldElement)errorDot);
        }
        Assert.assertEquals((double)0.0, (double)maxError.getReal(), (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)maxErrorDot.getReal(), (double)4.0E-7);
    }

    @Test
    public void testModelsMerging() {
        this.doTestModelsMerging((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestModelsMerging(final Field<T> field) {
        FirstOrderFieldDifferentialEquations problem = new FirstOrderFieldDifferentialEquations<T>(){

            public T[] computeDerivatives(T t, T[] y) {
                RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)2);
                yDot[0] = (RealFieldElement)y[1].negate();
                yDot[1] = y[0];
                return yDot;
            }

            public int getDimension() {
                return 2;
            }

            public void init(T t0, T[] y0, T finalTime) {
            }
        };
        ContinuousOutputFieldModel cm1 = new ContinuousOutputFieldModel();
        DormandPrince853FieldIntegrator integ1 = new DormandPrince853FieldIntegrator(field, 0.0, 1.0, 1.0E-8, 1.0E-8);
        integ1.addStepHandler((FieldStepHandler)cm1);
        RealFieldElement t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(Math.PI);
        RealFieldElement[] y0 = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        y0[0] = (RealFieldElement)((RealFieldElement)field.getOne()).negate();
        y0[1] = (RealFieldElement)field.getZero();
        integ1.integrate(new FieldExpandableODE(problem), new FieldODEState(t0, y0), (RealFieldElement)field.getZero());
        ContinuousOutputFieldModel cm2 = new ContinuousOutputFieldModel();
        DormandPrince853FieldIntegrator integ2 = new DormandPrince853FieldIntegrator(field, 0.0, 0.1, 1.0E-12, 1.0E-12);
        integ2.addStepHandler((FieldStepHandler)cm2);
        t0 = (RealFieldElement)((RealFieldElement)field.getZero()).add(Math.PI * 2);
        y0[0] = (RealFieldElement)field.getOne();
        y0[1] = (RealFieldElement)field.getZero();
        integ2.integrate(new FieldExpandableODE(problem), new FieldODEState(t0, y0), (RealFieldElement)((RealFieldElement)field.getZero()).add(Math.PI));
        ContinuousOutputFieldModel cm = new ContinuousOutputFieldModel();
        cm.append(cm2);
        cm.append(new ContinuousOutputFieldModel());
        cm.append(cm1);
        Assert.assertEquals((double)(Math.PI * 2), (double)cm.getInitialTime().getReal(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)cm.getFinalTime().getReal(), (double)1.0E-12);
        for (double t = 0.0; t < Math.PI * 2; t += 0.1) {
            FieldODEStateAndDerivative interpolated = cm.getInterpolatedState((RealFieldElement)((RealFieldElement)field.getZero()).add(t));
            Assert.assertEquals((double)FastMath.cos((double)t), (double)interpolated.getState()[0].getReal(), (double)1.0E-7);
            Assert.assertEquals((double)FastMath.sin((double)t), (double)interpolated.getState()[1].getReal(), (double)1.0E-7);
        }
    }

    @Test
    public void testErrorConditions() {
        this.doTestErrorConditions((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestErrorConditions(Field<T> field) {
        ContinuousOutputFieldModel cm = new ContinuousOutputFieldModel();
        cm.handleStep(this.buildInterpolator(field, 0.0, 1.0, new double[]{0.0, 1.0, -2.0}), true);
        Assert.assertTrue((boolean)this.checkAppendError(field, cm, 1.0, 2.0, new double[]{0.0, 1.0}));
        Assert.assertTrue((boolean)this.checkAppendError(field, cm, 10.0, 20.0, new double[]{0.0, 1.0, -2.0}));
        Assert.assertTrue((boolean)this.checkAppendError(field, cm, 1.0, 0.0, new double[]{0.0, 1.0, -2.0}));
        Assert.assertFalse((boolean)this.checkAppendError(field, cm, 1.0, 2.0, new double[]{0.0, 1.0, -2.0}));
    }

    private <T extends RealFieldElement<T>> boolean checkAppendError(Field<T> field, ContinuousOutputFieldModel<T> cm, double t0, double t1, double[] y) {
        try {
            ContinuousOutputFieldModel otherCm = new ContinuousOutputFieldModel();
            otherCm.handleStep(this.buildInterpolator(field, t0, t1, y), true);
            cm.append(otherCm);
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
        return false;
    }

    private <T extends RealFieldElement<T>> FieldStepInterpolator<T> buildInterpolator(Field<T> field, double t0, double t1, double[] y) {
        RealFieldElement[] fieldY = (RealFieldElement[])MathArrays.buildArray(field, (int)y.length);
        for (int i = 0; i < y.length; ++i) {
            fieldY[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(y[i]);
        }
        final FieldODEStateAndDerivative s0 = new FieldODEStateAndDerivative((RealFieldElement)((RealFieldElement)field.getZero()).add(t0), fieldY, fieldY);
        FieldODEStateAndDerivative s1 = new FieldODEStateAndDerivative((RealFieldElement)((RealFieldElement)field.getZero()).add(t1), fieldY, fieldY);
        FieldEquationsMapper mapper = new FieldExpandableODE(new FirstOrderFieldDifferentialEquations<T>(){

            public int getDimension() {
                return s0.getStateDimension();
            }

            public void init(T t0, T[] y0, T finalTime) {
            }

            public T[] computeDerivatives(T t, T[] y) {
                return y;
            }
        }).getMapper();
        return new DummyFieldStepInterpolator(t1 >= t0, s0, s1, s0, s1, mapper);
    }

    public void checkValue(double value, double reference) {
        Assert.assertTrue((FastMath.abs((double)(value - reference)) < 1.0E-10 ? 1 : 0) != 0);
    }
}

