/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import org.apache.commons.math3.genetics.BinaryChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.DummyBinaryChromosome;
import org.apache.commons.math3.genetics.OnePointCrossover;
import org.junit.Assert;
import org.junit.Test;

public class OnePointCrossoverTest {
    @Test
    public void testCrossover() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1, 0, 1, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        OnePointCrossover opc = new OnePointCrossover();
        for (int i = 0; i < 20; ++i) {
            ChromosomePair pair = opc.crossover((Chromosome)p1c, (Chromosome)p2c);
            Integer[] c1 = new Integer[p1.length];
            Integer[] c2 = new Integer[p2.length];
            c1 = ((BinaryChromosome)pair.getFirst()).getRepresentation().toArray(c1);
            c2 = ((BinaryChromosome)pair.getSecond()).getRepresentation().toArray(c2);
            Assert.assertEquals((Object)p1[0], (Object)c1[0]);
            Assert.assertEquals((Object)p2[0], (Object)c2[0]);
            Assert.assertEquals((Object)p1[p1.length - 1], (Object)c1[c1.length - 1]);
            Assert.assertEquals((Object)p2[p2.length - 1], (Object)c2[c2.length - 1]);
            Assert.assertEquals((Object)p1[2], (Object)c1[2]);
            Assert.assertEquals((Object)p2[2], (Object)c2[2]);
            Assert.assertEquals((Object)p1[3], (Object)c1[3]);
            Assert.assertEquals((Object)p2[3], (Object)c2[3]);
            Assert.assertEquals((Object)p1[7], (Object)c1[7]);
            Assert.assertEquals((Object)p2[7], (Object)c2[7]);
        }
    }
}

