/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere;
import org.apache.commons.math3.analysis.interpolation.InterpolatingMicrosphere2D;
import org.apache.commons.math3.analysis.interpolation.MicrosphereProjectionInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class MicrosphereProjectionInterpolatorTest {
    @Test
    public void testLinearFunction2D() {
        MultivariateFunction f = new MultivariateFunction(){

            public double value(double[] x) {
                if (x.length != 2) {
                    throw new IllegalArgumentException();
                }
                return 2.0 * x[0] - 3.0 * x[1] + 5.0;
            }
        };
        double darkFraction = 0.5;
        double darkThreshold = 0.01;
        double background = Double.NaN;
        double exponent = 1.1;
        boolean shareSphere = true;
        double noInterpolationTolerance = Math.ulp(1.0);
        MicrosphereProjectionInterpolator interpolator = new MicrosphereProjectionInterpolator(2, 500, 0.5, 0.01, Double.NaN, 1.1, true, noInterpolationTolerance);
        MicrosphereProjectionInterpolator interpolator2D = new MicrosphereProjectionInterpolator((InterpolatingMicrosphere)new InterpolatingMicrosphere2D(16, 0.5, 0.01, Double.NaN), 1.1, true, noInterpolationTolerance);
        double min = -1.0;
        double max = 1.0;
        double range = 2.0;
        int res = 5;
        int n = 25;
        int dim = 2;
        double[][] x = new double[25][2];
        double[] y = new double[25];
        int index = 0;
        for (int i = 0; i < 5; ++i) {
            double x1Val = MicrosphereProjectionInterpolatorTest.toCoordinate(-1.0, 2.0, 5, i);
            for (int j = 0; j < 5; ++j) {
                double x2Val = MicrosphereProjectionInterpolatorTest.toCoordinate(-1.0, 2.0, 5, j);
                x[index][0] = x1Val;
                x[index][1] = x2Val;
                y[index] = f.value(x[index]);
                ++index;
            }
        }
        MultivariateFunction p = interpolator.interpolate(x, y);
        MultivariateFunction p2D = interpolator2D.interpolate(x, y);
        double[] c = new double[2];
        int sampleIndex = 2;
        c[0] = x[2][0];
        c[1] = x[2][1];
        double expected = f.value(c);
        double result = p.value(c);
        double result2D = p2D.value(c);
        Assert.assertEquals((String)"on sample point (exact)", (double)expected, (double)result2D, (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((String)"on sample point (ND vs 2D)", (double)result2D, (double)result, (double)FastMath.ulp((double)1.0));
        c[0] = 0.654321;
        c[1] = -0.345678;
        expected = f.value(c);
        result = p.value(c);
        result2D = p2D.value(c);
        Assert.assertEquals((String)"interpolation (exact)", (double)expected, (double)result2D, (double)0.1);
        Assert.assertEquals((String)"interpolation (ND vs 2D)", (double)result2D, (double)result, (double)0.1);
        c[0] = -0.01;
        c[1] = 1.01;
        expected = f.value(c);
        result = p.value(c);
        result2D = p2D.value(c);
        Assert.assertFalse((boolean)Double.isNaN(result));
        Assert.assertFalse((boolean)Double.isNaN(result2D));
        Assert.assertEquals((String)"extrapolation (exact)", (double)expected, (double)result2D, (double)0.1);
        Assert.assertEquals((String)"extrapolation (ND vs 2D)", (double)result2D, (double)result, (double)0.01);
        c[0] = 20.0;
        c[1] = -30.0;
        result = p.value(c);
        Assert.assertTrue((String)(result + " should be NaN"), (boolean)Double.isNaN(result));
        result2D = p2D.value(c);
        Assert.assertTrue((String)(result2D + " should be NaN"), (boolean)Double.isNaN(result2D));
    }

    private static double toCoordinate(double min, double range, int res, int pixel) {
        return (double)pixel * range / (double)(res - 1) + min;
    }
}

