/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql.converters;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils2.converters.AbstractDateConverterTest;
import org.apache.commons.beanutils2.sql.converters.SqlTimestampConverter;
import org.junit.jupiter.api.Test;

public class SqlTimestampConverterTest
extends AbstractDateConverterTest<Timestamp> {
    @Override
    protected Class<Timestamp> getExpectedType() {
        return Timestamp.class;
    }

    private boolean isUSFormatWithComma() {
        DateFormat loc = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        return loc.format(new Date()).contains(",");
    }

    protected SqlTimestampConverter makeConverter() {
        return new SqlTimestampConverter();
    }

    protected SqlTimestampConverter makeConverter(Timestamp defaultValue) {
        return new SqlTimestampConverter(defaultValue);
    }

    @Override
    @Test
    public void testDefaultStringToTypeConvert() {
        SqlTimestampConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "2006-10-23 15:36:01.0";
        Object expected = this.toType("2006-10-23 15:36:01.0", "yyyy-MM-dd HH:mm:ss.S", null);
        this.validConversion(converter, expected, "2006-10-23 15:36:01.0");
        this.invalidConversion(converter, "2006/09/21 15:36:01.0");
        this.invalidConversion(converter, "2006-10-22");
        this.invalidConversion(converter, "15:36:01");
    }

    @Override
    @Test
    public void testLocale() {
        String testString;
        String pattern;
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        this.isUSFormatWithComma();
        SqlTimestampConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        if (this.isUSFormatWithComma()) {
            pattern = "M/d/yy, h:mm a";
            testString = "3/21/06, 3:06 PM";
        } else {
            pattern = "M/d/yy h:mm a";
            testString = "3/21/06 3:06 PM";
        }
        Object expected = this.toType(testString, pattern, null);
        this.validConversion(converter, expected, testString);
        this.invalidConversion(converter, (Object)null);
        this.invalidConversion(converter, "");
        this.invalidConversion(converter, "13:05 pm");
        this.invalidConversion(converter, "11:05 p");
        this.invalidConversion(converter, "11.05 pm");
        this.invalidConversion(converter, 2);
        Locale.setDefault(defaultLocale);
    }

    @Override
    protected Timestamp toType(Calendar value) {
        return new Timestamp(this.getTimeInMillis(value));
    }
}

