/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.LazyDynaBean;
import org.apache.commons.beanutils2.LazyDynaClass;
import org.apache.commons.beanutils2.LazyDynaMap;
import org.apache.commons.beanutils2.PropertyUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LazyDynaBeanTest {
    protected LazyDynaBean bean;
    protected LazyDynaClass dynaClass;
    protected String testProperty = "myProperty";
    protected String testPropertyA = "myProperty-A";
    protected String testPropertyB = "myProperty-B";
    protected String testString1 = "myStringValue-1";
    protected String testString2 = "myStringValue-2";
    protected Integer testInteger1 = 30;
    protected Integer testInteger2 = 40;
    protected String testKey = "myKey";

    @BeforeEach
    public void setUp() throws Exception {
        this.bean = new LazyDynaBean();
        this.dynaClass = (LazyDynaClass)this.bean.getDynaClass();
        this.dynaClass.setReturnNull(true);
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testIndexedDynaBeanArray() {
        int index = 3;
        LazyDynaMap[] objectArray = new LazyDynaMap[]{};
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        this.dynaClass.add(this.testProperty, objectArray.getClass());
        Assertions.assertEquals(objectArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Indexed Property exists");
        Assertions.assertEquals(objectArray.getClass(), this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        for (int i = 3; i >= 0; --i) {
            Assertions.assertEquals(LazyDynaMap.class, this.bean.get(this.testProperty, 3).getClass(), (String)"Check Array Components initialized");
        }
        this.dynaClass.add(this.testPropertyB, objectArray.getClass());
        LazyDynaMap newMap = new LazyDynaMap();
        newMap.set(this.testPropertyB, (Object)this.testString2);
        this.bean.set(this.testPropertyA, 3, (Object)newMap);
        Assertions.assertEquals((Object)this.testString2, (Object)((DynaBean)this.bean.get(this.testPropertyA, 3)).get(this.testPropertyB), (String)"Check Indexed Value is correct(a)");
    }

    @Test
    public void testIndexedInvalidType() {
        int index = 3;
        this.dynaClass.add(this.testProperty, String.class);
        Assertions.assertFalse((boolean)this.dynaClass.getDynaProperty(this.testProperty).isIndexed(), (String)"Check Property is not indexed");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set(this.testProperty, 3, (Object)this.testString1));
    }

    @Test
    public void testIndexedLinkedList() {
        int index = 3;
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        this.dynaClass.add(this.testProperty, LinkedList.class);
        Assertions.assertTrue((boolean)this.dynaClass.getDynaProperty(this.testProperty).isIndexed(), (String)"Check Property is indexed");
        Assertions.assertEquals(LinkedList.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Property is correct type");
        Assertions.assertEquals(LinkedList.class, this.bean.get(this.testProperty).getClass(), (String)"Check Property type is correct");
        this.bean.set(this.testProperty, index, (Object)this.testString1);
        Assertions.assertEquals(LinkedList.class, this.bean.get(this.testProperty).getClass(), (String)"Check Property type is correct");
        Assertions.assertEquals((Object)this.testString1, (Object)this.bean.get(this.testProperty, index), (String)"Check First Indexed Value is correct");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((LinkedList)this.bean.get(this.testProperty)).size(), (String)"Check First Array length is correct");
        this.bean.set(this.testProperty, index += 2, (Object)this.testInteger1);
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index), (String)"Check Second Indexed Value is correct");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((LinkedList)this.bean.get(this.testProperty)).size(), (String)"Check Second Array length is correct");
    }

    @Test
    public void testIndexedObjectArray() {
        int index = 3;
        String[] objectArray = new String[]{};
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        this.dynaClass.add(this.testProperty, objectArray.getClass());
        Assertions.assertEquals(objectArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Indexed Property exists");
        Assertions.assertEquals(objectArray.getClass(), this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        this.bean.set(this.testProperty, index, (Object)this.testString1);
        Assertions.assertNotNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is not null");
        Assertions.assertEquals(objectArray.getClass(), this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        Assertions.assertEquals((Object)this.testString1, (Object)this.bean.get(this.testProperty, index), (String)"Check First Indexed Value is correct(a)");
        Assertions.assertEquals((Object)this.testString1, (Object)((String[])this.bean.get(this.testProperty))[index], (String)"Check First Indexed Value is correct(b)");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((String[])this.bean.get(this.testProperty)).length, (String)"Check Array length is correct");
        this.bean.set(this.testProperty, index += 2, (Object)this.testString2);
        Assertions.assertEquals((Object)this.testString2, (Object)this.bean.get(this.testProperty, index), (String)"Check Second Indexed Value is correct(a)");
        Assertions.assertEquals((Object)this.testString2, (Object)((String[])this.bean.get(this.testProperty))[index], (String)"Check Second Indexed Value is correct(b)");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((String[])this.bean.get(this.testProperty)).length, (String)"Check Second Array length is correct");
    }

    @Test
    public void testIndexedPrimitiveArray() {
        int index = 3;
        int[] primitiveArray = new int[]{};
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        this.dynaClass.add(this.testProperty, primitiveArray.getClass());
        Assertions.assertEquals(primitiveArray.getClass(), (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Indexed Property exists");
        Assertions.assertEquals(primitiveArray.getClass(), this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        this.bean.set(this.testProperty, index, (Object)this.testInteger1);
        Assertions.assertNotNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is not null");
        Assertions.assertEquals(primitiveArray.getClass(), this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index), (String)"Check First Indexed Value is correct(a)");
        Assertions.assertEquals((Integer)this.testInteger1, (Integer)((int[])this.bean.get(this.testProperty))[index], (String)"Check First Indexed Value is correct(b)");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((int[])this.bean.get(this.testProperty)).length, (String)"Check Array length is correct");
        this.bean.set(this.testProperty, index += 2, (Object)this.testInteger2);
        Assertions.assertEquals((Object)this.testInteger2, (Object)this.bean.get(this.testProperty, index), (String)"Check Second Indexed Value is correct(a)");
        Assertions.assertEquals((Integer)this.testInteger2, (Integer)((int[])this.bean.get(this.testProperty))[index], (String)"Check Second Indexed Value is correct(b)");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((int[])this.bean.get(this.testProperty)).length, (String)"Check Second Array length is correct");
    }

    @Test
    public void testIndexedPropertyDefault() {
        int index = 3;
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        Assertions.assertNull((Object)this.bean.get(this.testProperty, index), (String)"Check Indexed value is null");
        this.bean.set(this.testProperty, index, (Object)this.testInteger1);
        Assertions.assertNotNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is not null");
        Assertions.assertEquals(ArrayList.class, this.bean.get(this.testProperty).getClass(), (String)"Check Indexed Property is correct type");
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty, index), (String)"Check First Indexed Value is correct");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((ArrayList)this.bean.get(this.testProperty)).size(), (String)"Check First Array length is correct");
        this.bean.set(this.testProperty, index += 2, (Object)this.testString1);
        Assertions.assertEquals((Object)this.testString1, (Object)this.bean.get(this.testProperty, index), (String)"Check Second Indexed Value is correct");
        Assertions.assertEquals((Integer)(index + 1), (Integer)((ArrayList)this.bean.get(this.testProperty)).size(), (String)"Check Second Array length is correct");
    }

    @Test
    public void testIndexedPropertyRestricted() {
        int index = 3;
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"Check MutableDynaClass is restricted");
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set(this.testProperty, 3, (Object)this.testInteger1));
    }

    @Test
    public void testIndexedPropertyUtils() throws Exception {
        int index = 3;
        this.dynaClass.setReturnNull(false);
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"Check Indexed Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Indexed Property is null");
        Assertions.assertNull((Object)this.bean.get(this.testProperty, 3), (String)"Check Indexed value is null");
        PropertyUtils.setProperty((Object)this.bean, (String)(this.testProperty + "[" + 3 + "]"), (Object)this.testString1);
        Assertions.assertEquals((Object)this.testString1, (Object)this.bean.get(this.testProperty, 3), (String)"Check Indexed Bean Value is correct");
    }

    @Test
    public void testMappedInvalidType() {
        this.dynaClass.add(this.testProperty, String.class);
        Assertions.assertFalse((boolean)this.dynaClass.getDynaProperty(this.testProperty).isMapped(), (String)"Check Property is not mapped");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1));
    }

    @Test
    public void testMappedPropertyDefault() {
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Mapped Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Map is null");
        Assertions.assertNull((Object)this.bean.get(this.testProperty, this.testKey), (String)"Check Mapped Value is null");
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        Assertions.assertEquals(HashMap.class, this.bean.get(this.testProperty).getClass(), (String)"Check Mapped Property exists");
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty, this.testKey), (String)"Check First Mapped Value is correct(a)");
        Assertions.assertEquals((Object)this.testInteger1, ((HashMap)this.bean.get(this.testProperty)).get(this.testKey), (String)"Check First Mapped Value is correct(b)");
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        Assertions.assertEquals((Object)this.testInteger2, (Object)this.bean.get(this.testProperty, this.testKey), (String)"Check Second Mapped Value is correct(a)");
        Assertions.assertEquals((Object)this.testInteger2, ((HashMap)this.bean.get(this.testProperty)).get(this.testKey), (String)"Check Second Mapped Value is correct(b)");
    }

    @Test
    public void testMappedPropertyRestricted() {
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"Check MutableDynaClass is restricted");
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1));
    }

    @Test
    public void testMappedPropertyTreeMap() {
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Mapped Property doesn't exist");
        this.dynaClass.add(this.testProperty, TreeMap.class);
        Assertions.assertTrue((boolean)this.dynaClass.getDynaProperty(this.testProperty).isMapped(), (String)"Check Property is mapped");
        Assertions.assertEquals(TreeMap.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Property is correct type");
        Assertions.assertEquals(TreeMap.class, this.bean.get(this.testProperty).getClass(), (String)"Check Mapped Property exists");
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger1);
        Assertions.assertEquals(TreeMap.class, this.bean.get(this.testProperty).getClass(), (String)"Check Mapped Property exists");
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty, this.testKey), (String)"Check First Mapped Value is correct(a)");
        Assertions.assertEquals((Object)this.testInteger1, ((TreeMap)this.bean.get(this.testProperty)).get(this.testKey), (String)"Check First Mapped Value is correct(b)");
        this.bean.set(this.testProperty, this.testKey, (Object)this.testInteger2);
        Assertions.assertEquals((Object)this.testInteger2, (Object)this.bean.get(this.testProperty, this.testKey), (String)"Check Second Mapped Value is correct(a)");
        Assertions.assertEquals((Object)this.testInteger2, ((TreeMap)this.bean.get(this.testProperty)).get(this.testKey), (String)"Check Second Mapped Value is correct(b)");
    }

    @Test
    public void testMappedPropertyUtils() throws Exception {
        this.dynaClass.setReturnNull(false);
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"Check Mapped Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Map is null");
        Assertions.assertNull((Object)this.bean.get(this.testProperty, this.testKey), (String)"Check Mapped Value is null");
        PropertyUtils.setProperty((Object)this.bean, (String)(this.testProperty + "(" + this.testKey + ")"), (Object)this.testString1);
        Assertions.assertEquals((Object)this.testString1, (Object)this.bean.get(this.testProperty, this.testKey), (String)"Check Mapped Bean Value is correct");
    }

    @Test
    public void testNullProperty() {
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is null");
        this.bean.set(this.testProperty, null);
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is still null");
    }

    @Test
    public void testSimpleProperty() {
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is null");
        this.bean.set(this.testProperty, (Object)this.testInteger1);
        Assertions.assertEquals((Object)this.testInteger1, (Object)this.bean.get(this.testProperty), (String)"Check First Value is correct");
        Assertions.assertEquals(Integer.class, (Object)this.dynaClass.getDynaProperty(this.testProperty).getType(), (String)"Check Property type is correct");
        this.bean.set(this.testProperty, (Object)this.testInteger2);
        Assertions.assertEquals((Object)this.testInteger2, (Object)this.bean.get(this.testProperty), (String)"Check Second Value is correct");
        Assertions.assertThrows(ConversionException.class, () -> this.bean.set(this.testProperty, (Object)this.testString1));
    }

    @Test
    public void testSimplePropertyRestricted() {
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"Check MutableDynaClass is restricted");
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"Check Property doesn't exist");
        Assertions.assertNull((Object)this.bean.get(this.testProperty), (String)"Check Value is null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set(this.testProperty, (Object)this.testString1));
    }
}

