/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.IndexedTestBean;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.bugs.other.Jira492IndexedListsSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IndexedPropertyTest {
    private IndexedTestBean bean;
    private BeanUtilsBean beanUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;
    private String[] testArray;
    private String[] newArray;
    private List<String> testList;
    private List<Object> newList;
    private ArrayList<Object> arrayList;

    @BeforeEach
    public void setUp() {
        this.beanUtilsBean = new BeanUtilsBean();
        this.propertyUtilsBean = this.beanUtilsBean.getPropertyUtils();
        this.testArray = new String[]{"array-0", "array-1", "array-2"};
        this.newArray = new String[]{"newArray-0", "newArray-1", "newArray-2"};
        this.testList = new ArrayList<String>();
        this.testList.add("list-0");
        this.testList.add("list-1");
        this.testList.add("list-2");
        this.newList = new ArrayList<Object>();
        this.newList.add("newList-0");
        this.newList.add("newList-1");
        this.newList.add("newList-2");
        this.arrayList = new ArrayList();
        this.arrayList.add("arrayList-0");
        this.arrayList.add("arrayList-1");
        this.arrayList.add("arrayList-2");
        this.bean = new IndexedTestBean();
        this.bean.setStringArray(this.testArray);
        this.bean.setStringList(this.testList);
        this.bean.setArrayList(this.arrayList);
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testArrayIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assertions.assertNotNull((Object)descriptor, (String)"No Array Descriptor");
        Assertions.assertEquals(IndexedPropertyDescriptor.class, descriptor.getClass(), (String)"Not IndexedPropertyDescriptor");
        Assertions.assertEquals(this.testArray.getClass(), descriptor.getPropertyType(), (String)"PropertyDescriptor Type invalid");
    }

    @Test
    public void testArrayIndexedReadMethod() throws Exception {
        IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assertions.assertNotNull((Object)descriptor.getIndexedReadMethod(), (String)"No Array Indexed Read Method");
    }

    @Test
    public void testArrayIndexedWriteMethod() throws Exception {
        IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assertions.assertNotNull((Object)descriptor.getIndexedWriteMethod(), (String)"No Array Indexed Write Method");
    }

    @Test
    public void testArrayListIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assertions.assertNotNull((Object)descriptor, (String)"No ArrayList Descriptor");
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            Assertions.assertEquals(IndexedPropertyDescriptor.class, descriptor.getClass(), (String)"Not IndexedPropertyDescriptor");
        }
        Assertions.assertEquals(ArrayList.class, descriptor.getPropertyType(), (String)"PropertyDescriptor Type invalid");
    }

    @Test
    public void testArrayListReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assertions.assertNotNull((Object)descriptor.getReadMethod(), (String)"No ArrayList Read Method");
    }

    @Test
    public void testArrayListWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assertions.assertNotNull((Object)descriptor.getWriteMethod(), (String)"No ArrayList Write Method");
    }

    @Test
    public void testArrayReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assertions.assertNotNull((Object)descriptor.getReadMethod(), (String)"No Array Read Method");
    }

    @Test
    public void testArrayWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assertions.assertNotNull((Object)descriptor.getWriteMethod(), (String)"No Array Write Method");
    }

    @Test
    public void testGetArray() throws Exception {
        Assertions.assertEquals((Object)this.testArray, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringArray"));
    }

    @Test
    public void testGetArrayAsString() throws Exception {
        Assertions.assertEquals((Object)"array-0", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray"));
    }

    @Test
    public void testGetArrayItemA() throws Exception {
        Assertions.assertEquals((Object)"array-1", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray[1]"));
    }

    @Test
    public void testGetArrayItemB() throws Exception {
        Assertions.assertEquals((Object)"array-1", (Object)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringArray", 1));
    }

    @Test
    public void testGetArrayList() throws Exception {
        Assertions.assertEquals(this.arrayList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "arrayList"));
    }

    @Test
    public void testGetList() throws Exception {
        Assertions.assertEquals(this.testList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringList"));
    }

    @Test
    public void testGetListAsString() throws Exception {
        Assertions.assertEquals((Object)"list-0", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringList"));
    }

    @Test
    public void testGetListItemA() throws Exception {
        Assertions.assertEquals((Object)"list-1", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringList[1]"));
    }

    @Test
    public void testGetListItemB() throws Exception {
        Assertions.assertEquals((Object)"list-1", (Object)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringList", 1));
    }

    @Test
    public void testListIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assertions.assertNotNull((Object)descriptor, (String)"No List Descriptor");
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            Assertions.assertEquals(IndexedPropertyDescriptor.class, descriptor.getClass(), (String)"Not IndexedPropertyDescriptor");
        }
        Assertions.assertEquals(List.class, descriptor.getPropertyType(), (String)"PropertyDescriptor Type invalid");
    }

    @Test
    public void testListIndexedReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assertions.assertNotNull((Object)descriptor, (String)"stringList descriptor not found");
        Assumptions.assumeTrue((boolean)Jira492IndexedListsSupport.supportsIndexedLists(), (String)"JDK does not support index bean properties on java.util.List");
        Assertions.assertNotNull((Object)((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod(), (String)"No List Indexed Read Method");
    }

    @Test
    public void testListIndexedWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assertions.assertNotNull((Object)descriptor, (String)"stringList descriptor not found");
        Assumptions.assumeTrue((boolean)Jira492IndexedListsSupport.supportsIndexedLists(), (String)"JDK does not support index bean properties on java.util.List");
        Assertions.assertNotNull((Object)((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod(), (String)"No List Indexed Write Method");
    }

    @Test
    public void testListReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assertions.assertNotNull((Object)descriptor.getReadMethod(), (String)"No List Read Method");
    }

    @Test
    public void testListWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assertions.assertNotNull((Object)descriptor.getWriteMethod(), (String)"No List Write Method");
    }

    @Test
    public void testSetArray() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringArray", (Object)this.newArray);
        String[] value = this.bean.getStringArray();
        Assertions.assertEquals(this.newArray.getClass(), value.getClass(), (String)"Type is different");
        String[] array = value;
        Assertions.assertEquals((int)this.newArray.length, (int)array.length, (String)"Array Length is different");
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertEquals((Object)this.newArray[i], (Object)array[i], (String)("Element " + i + " is different"));
        }
    }

    @Test
    public void testSetArrayItemA() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringArray[1]", (Object)"modified-1");
        Assertions.assertEquals((Object)"modified-1", (Object)this.bean.getStringArray(1));
    }

    @Test
    public void testSetArrayItemB() throws Exception {
        this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringArray", 1, (Object)"modified-1");
        Assertions.assertEquals((Object)"modified-1", (Object)this.bean.getStringArray(1));
    }

    @Test
    public void testSetArrayList() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "arrayList", this.newList);
        ArrayList<Object> value = this.bean.getArrayList();
        Assertions.assertEquals(this.newList.getClass(), value.getClass(), (String)"Type is different");
        List list = value;
        Assertions.assertEquals((int)this.newList.size(), (int)list.size(), (String)"List size is different");
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((Object)this.newList.get(i), list.get(i), (String)("Element " + i + " is different"));
        }
    }

    @Test
    public void testSetList() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringList", this.newList);
        List<String> value = this.bean.getStringList();
        Assertions.assertEquals(this.newList.getClass(), value.getClass(), (String)"Type is different");
        List<String> list = value;
        Assertions.assertEquals((int)this.newList.size(), (int)list.size(), (String)"List size is different");
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((Object)this.newList.get(i), (Object)list.get(i), (String)("Element " + i + " is different"));
        }
    }

    @Test
    public void testSetListItemA() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringList[1]", (Object)"modified-1");
        Assertions.assertEquals((Object)"modified-1", (Object)this.bean.getStringList(1));
    }

    @Test
    public void testSetListItemB() throws Exception {
        this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringList", 1, (Object)"modified-1");
        Assertions.assertEquals((Object)"modified-1", (Object)this.bean.getStringList(1));
    }
}

