/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;
import java.io.Serializable;

public final class Point3D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;

    public Point3D() {
    }

    public Point3D(Point3D other) {
        this.setCoords(other);
    }

    public Point3D(double x, double y, double z) {
        this.setCoords(x, y, z);
    }

    public static Point3D construct(double x, double y, double z) {
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        return pt;
    }

    public void setCoords(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setCoords(Point3D other) {
        this.setCoords(other.x, other.y, other.z);
    }

    public void setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public double dotProduct(Point3D other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public double sqrLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void sub(Point3D other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public void sub(Point3D p1, Point3D p2) {
        this.x = p1.x - p2.x;
        this.y = p1.y - p2.y;
        this.z = p1.z - p2.z;
    }

    public void scale(double f, Point3D other) {
        this.x = f * other.x;
        this.y = f * other.y;
        this.z = f * other.z;
    }

    public void mul(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    void _setNan() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
        this.z = NumberUtils.NaN();
    }

    boolean _isNan() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y) || NumberUtils.isNaN(this.z);
    }
}

