/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AppServiceMsiCredential;
import com.azure.identity.ArcIdentityCredential;
import com.azure.identity.ClientAssertionCredential;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.ServiceFabricMsiCredential;
import com.azure.identity.VirtualMachineMsiCredential;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private final ManagedIdentityServiceCredential managedIdentityServiceCredential;
    private final ClientLogger logger = new ClientLogger(ManagedIdentityCredential.class);
    static final String PROPERTY_IMDS_ENDPOINT = "IMDS_ENDPOINT";
    static final String PROPERTY_IDENTITY_SERVER_THUMBPRINT = "IDENTITY_SERVER_THUMBPRINT";
    static final String AZURE_FEDERATED_TOKEN_FILE = "AZURE_FEDERATED_TOKEN_FILE";

    ManagedIdentityCredential(String clientId, IdentityClientOptions identityClientOptions) {
        Configuration configuration;
        IdentityClientBuilder clientBuilder = new IdentityClientBuilder().clientId(clientId).identityClientOptions(identityClientOptions);
        Configuration configuration2 = configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        if (configuration.contains("MSI_ENDPOINT")) {
            this.managedIdentityServiceCredential = new AppServiceMsiCredential(clientId, clientBuilder.build());
        } else if (configuration.contains("IDENTITY_ENDPOINT")) {
            this.managedIdentityServiceCredential = configuration.contains("IDENTITY_HEADER") ? (configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT) != null ? new ServiceFabricMsiCredential(clientId, clientBuilder.build()) : new VirtualMachineMsiCredential(clientId, clientBuilder.build())) : (configuration.get(PROPERTY_IMDS_ENDPOINT) != null ? new ArcIdentityCredential(clientId, clientBuilder.build()) : new VirtualMachineMsiCredential(clientId, clientBuilder.build()));
        } else if (configuration.contains("AZURE_TENANT_ID") && configuration.get(AZURE_FEDERATED_TOKEN_FILE) != null) {
            String clientIdentifier = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
            clientBuilder.clientId(clientIdentifier);
            clientBuilder.tenantId(configuration.get("AZURE_TENANT_ID"));
            clientBuilder.clientAssertionPath(configuration.get(AZURE_FEDERATED_TOKEN_FILE));
            clientBuilder.clientAssertionTimeout(Duration.ofMinutes(5L));
            this.managedIdentityServiceCredential = new ClientAssertionCredential(clientIdentifier, clientBuilder.build());
        } else {
            this.managedIdentityServiceCredential = new VirtualMachineMsiCredential(clientId, clientBuilder.build());
        }
        LoggingUtil.logAvailableEnvironmentVariables(this.logger, configuration);
    }

    public String getClientId() {
        return this.managedIdentityServiceCredential.getClientId();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.managedIdentityServiceCredential == null) {
            return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. The Target Azure platform could not be determined from environment variables.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/net/identity/managedidentitycredential/troubleshoot"))));
        }
        return this.managedIdentityServiceCredential.authenticate(request).doOnSuccess(t -> this.logger.info("Azure Identity => Managed Identity environment: {}", new Object[]{this.managedIdentityServiceCredential.getEnvironment()})).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }
}

