/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.compressors;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IPrefixSlotManager;
import org.apache.hyracks.storage.am.btree.frames.BTreeFieldPrefixNSMLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeFieldPrefixTupleReference;
import org.apache.hyracks.storage.am.btree.tuples.BTreeTypeAwareTupleWriter;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameCompressor;
import org.apache.hyracks.storage.common.MultiComparator;

public class FieldPrefixCompressor
implements ITreeIndexFrameCompressor {
    private final float ratioThreshold;
    private final int occurrenceThreshold;
    private final ITypeTraits[] typeTraits;
    private final ITypeTraits nullTypeTraits;
    private final INullIntrospector nullIntrospector;

    public FieldPrefixCompressor(ITypeTraits[] typeTraits, float ratioThreshold, int occurrenceThreshold, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        this.typeTraits = typeTraits;
        this.ratioThreshold = ratioThreshold;
        this.occurrenceThreshold = occurrenceThreshold;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
    }

    public boolean compress(ITreeIndexFrame indexFrame, MultiComparator cmp) throws Exception {
        int i;
        int[] newPrefixSlots;
        BTreeFieldPrefixNSMLeafFrame frame = (BTreeFieldPrefixNSMLeafFrame)indexFrame;
        int tupleCount = frame.getTupleCount();
        if (tupleCount <= 0) {
            frame.setPrefixTupleCount(0);
            frame.setFreeSpaceOff(frame.getOrigFreeSpaceOff());
            frame.setTotalFreeSpace(frame.getOrigTotalFreeSpace());
            return false;
        }
        if (cmp.getKeyFieldCount() == 1) {
            return false;
        }
        int uncompressedTupleCount = frame.getUncompressedTupleCount();
        float ratio = (float)uncompressedTupleCount / (float)tupleCount;
        if (ratio < this.ratioThreshold) {
            return false;
        }
        IBinaryComparator[] cmps = cmp.getComparators();
        int fieldCount = this.typeTraits.length;
        ByteBuffer buf = frame.getBuffer();
        byte[] pageArray = buf.array();
        IPrefixSlotManager slotManager = frame.getSlotManager();
        ArrayList<KeyPartition> keyPartitions = this.getKeyPartitions(frame, cmp, this.occurrenceThreshold);
        if (keyPartitions.size() == 0) {
            return false;
        }
        int totalSlotsNeeded = 0;
        int totalPrefixBytes = 0;
        for (KeyPartition kp : keyPartitions) {
            for (int j = 0; j < kp.pmi.length; ++j) {
                int benefitMinusCost = kp.pmi[j].spaceBenefit - kp.pmi[j].spaceCost;
                if (benefitMinusCost <= kp.maxBenefitMinusCost) continue;
                kp.maxBenefitMinusCost = benefitMinusCost;
                kp.maxPmiIndex = j;
            }
            if (kp.maxBenefitMinusCost <= 0) continue;
            totalPrefixBytes += kp.pmi[kp.maxPmiIndex].prefixBytes;
            totalSlotsNeeded += kp.pmi[kp.maxPmiIndex].prefixSlotsNeeded;
        }
        if (totalSlotsNeeded > 254) {
            KeyPartition kp;
            SortByHeuristic heuristicComparator = new SortByHeuristic();
            Collections.sort(keyPartitions, heuristicComparator);
            int slotsUsed = 0;
            int numberKeyPartitions = -1;
            for (int i2 = 0; i2 < keyPartitions.size(); ++i2) {
                kp = keyPartitions.get(i2);
                if ((slotsUsed += kp.pmi[kp.maxPmiIndex].prefixSlotsNeeded) <= 254) continue;
                numberKeyPartitions = i2 + 1;
                slotsUsed -= kp.pmi[kp.maxPmiIndex].prefixSlotsNeeded;
                break;
            }
            newPrefixSlots = new int[slotsUsed];
            while (keyPartitions.size() >= numberKeyPartitions) {
                int lastIndex = keyPartitions.size() - 1;
                kp = keyPartitions.get(lastIndex);
                if (kp.maxBenefitMinusCost > 0) {
                    totalPrefixBytes -= kp.pmi[kp.maxPmiIndex].prefixBytes;
                }
                keyPartitions.remove(lastIndex);
            }
            SortByOriginalRank originalRankComparator = new SortByOriginalRank();
            Collections.sort(keyPartitions, originalRankComparator);
        } else {
            newPrefixSlots = new int[totalSlotsNeeded];
        }
        int[] newTupleSlots = new int[tupleCount];
        int prefixFreeSpace = frame.getOrigFreeSpaceOff();
        int tupleFreeSpace = prefixFreeSpace + totalPrefixBytes;
        byte[] buffer = new byte[buf.capacity()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        int kpIndex = 0;
        int prefixTupleIndex = 0;
        uncompressedTupleCount = 0;
        BTreeTypeAwareTupleWriter tupleWriter = new BTreeTypeAwareTupleWriter(this.typeTraits, false, this.nullTypeTraits, this.nullIntrospector);
        BTreeFieldPrefixTupleReference tupleToWrite = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
        tupleToWrite.setFieldCount(fieldCount);
        for (int tupleIndex = 0; tupleIndex < tupleCount; ++tupleIndex) {
            if (kpIndex < keyPartitions.size()) {
                if (tupleIndex == keyPartitions.get((int)kpIndex).firstTupleIndex) {
                    int fieldCountToCompress = keyPartitions.get((int)kpIndex).maxPmiIndex + 1;
                    int segmentStart = keyPartitions.get((int)kpIndex).firstTupleIndex;
                    int tuplesInSegment = 1;
                    BTreeFieldPrefixTupleReference prevTuple = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
                    prevTuple.setFieldCount(fieldCount);
                    BTreeFieldPrefixTupleReference tuple = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
                    tuple.setFieldCount(fieldCount);
                    for (int i3 = tupleIndex + 1; i3 <= keyPartitions.get((int)kpIndex).lastTupleIndex; ++i3) {
                        prevTuple.resetByTupleIndex(frame, i3 - 1);
                        tuple.resetByTupleIndex(frame, i3);
                        int prefixFieldsMatch = 0;
                        for (int j = 0; j < fieldCountToCompress && cmps[j].compare(pageArray, prevTuple.getFieldStart(j), prevTuple.getFieldLength(j), pageArray, tuple.getFieldStart(j), tuple.getFieldLength(j)) == 0; ++j) {
                            ++prefixFieldsMatch;
                        }
                        int processSegments = 0;
                        if (prefixFieldsMatch == fieldCountToCompress) {
                            ++tuplesInSegment;
                        } else {
                            ++processSegments;
                        }
                        if (i3 == keyPartitions.get((int)kpIndex).lastTupleIndex) {
                            ++processSegments;
                        }
                        for (int r = 0; r < processSegments; ++r) {
                            int j;
                            if (tuplesInSegment < this.occurrenceThreshold || fieldCountToCompress <= 0) {
                                for (j = 0; j < tuplesInSegment; ++j) {
                                    int slotNum = segmentStart + j;
                                    tupleToWrite.resetByTupleIndex(frame, slotNum);
                                    newTupleSlots[tupleCount - 1 - slotNum] = slotManager.encodeSlotFields(255, tupleFreeSpace);
                                    tupleFreeSpace += tupleWriter.writeTuple((ITupleReference)tupleToWrite, byteBuffer, tupleFreeSpace);
                                }
                                uncompressedTupleCount += tuplesInSegment;
                            } else {
                                newPrefixSlots[newPrefixSlots.length - 1 - prefixTupleIndex] = slotManager.encodeSlotFields(fieldCountToCompress, prefixFreeSpace);
                                prefixFreeSpace += tupleWriter.writeTupleFields((ITupleReference)prevTuple, 0, fieldCountToCompress, byteBuffer.array(), prefixFreeSpace);
                                for (j = 0; j < tuplesInSegment; ++j) {
                                    int currTupleIndex = segmentStart + j;
                                    tupleToWrite.resetByTupleIndex(frame, currTupleIndex);
                                    newTupleSlots[tupleCount - 1 - currTupleIndex] = slotManager.encodeSlotFields(prefixTupleIndex, tupleFreeSpace);
                                    tupleFreeSpace += tupleWriter.writeTupleFields((ITupleReference)tupleToWrite, fieldCountToCompress, fieldCount - fieldCountToCompress, byteBuffer.array(), tupleFreeSpace);
                                }
                                ++prefixTupleIndex;
                            }
                            segmentStart = i3;
                            tuplesInSegment = 1;
                        }
                    }
                    tupleIndex = keyPartitions.get((int)kpIndex).lastTupleIndex;
                    ++kpIndex;
                    continue;
                }
                tupleToWrite.resetByTupleIndex(frame, tupleIndex);
                newTupleSlots[tupleCount - 1 - tupleIndex] = slotManager.encodeSlotFields(255, tupleFreeSpace);
                tupleFreeSpace += tupleWriter.writeTuple((ITupleReference)tupleToWrite, byteBuffer, tupleFreeSpace);
                ++uncompressedTupleCount;
                continue;
            }
            tupleToWrite.resetByTupleIndex(frame, tupleIndex);
            newTupleSlots[tupleCount - 1 - tupleIndex] = slotManager.encodeSlotFields(255, tupleFreeSpace);
            tupleFreeSpace += tupleWriter.writeTuple((ITupleReference)tupleToWrite, byteBuffer, tupleFreeSpace);
            ++uncompressedTupleCount;
        }
        if (prefixFreeSpace != frame.getOrigFreeSpaceOff() + totalPrefixBytes) {
            throw new Exception("ERROR: Number of prefix bytes written don't match computed number");
        }
        int totalSpace = tupleFreeSpace + newTupleSlots.length * slotManager.getSlotSize() + newPrefixSlots.length * slotManager.getSlotSize();
        if (totalSpace > buf.capacity()) {
            return false;
        }
        int freeSpaceAfterInit = frame.getOrigFreeSpaceOff();
        System.arraycopy(buffer, freeSpaceAfterInit, pageArray, freeSpaceAfterInit, tupleFreeSpace - freeSpaceAfterInit);
        int slotOffRunner = buf.capacity() - slotManager.getSlotSize();
        for (i = 0; i < newPrefixSlots.length; ++i) {
            buf.putInt(slotOffRunner, newPrefixSlots[newPrefixSlots.length - 1 - i]);
            slotOffRunner -= slotManager.getSlotSize();
        }
        for (i = 0; i < newTupleSlots.length; ++i) {
            buf.putInt(slotOffRunner, newTupleSlots[newTupleSlots.length - 1 - i]);
            slotOffRunner -= slotManager.getSlotSize();
        }
        frame.setFreeSpaceOff(tupleFreeSpace);
        frame.setPrefixTupleCount(newPrefixSlots.length);
        frame.setUncompressedTupleCount(uncompressedTupleCount);
        int totalFreeSpace = buf.capacity() - tupleFreeSpace - (newTupleSlots.length + newPrefixSlots.length) * slotManager.getSlotSize();
        frame.setTotalFreeSpace(totalFreeSpace);
        return true;
    }

    private ArrayList<KeyPartition> getKeyPartitions(BTreeFieldPrefixNSMLeafFrame frame, MultiComparator cmp, int occurrenceThreshold) throws HyracksDataException {
        IBinaryComparator[] cmps = cmp.getComparators();
        int fieldCount = this.typeTraits.length;
        int maxCmps = cmps.length - 1;
        ByteBuffer buf = frame.getBuffer();
        byte[] pageArray = buf.array();
        IPrefixSlotManager slotManager = frame.getSlotManager();
        ArrayList<KeyPartition> keyPartitions = new ArrayList<KeyPartition>();
        KeyPartition kp = new KeyPartition(maxCmps);
        keyPartitions.add(kp);
        BTreeTypeAwareTupleWriter tupleWriter = new BTreeTypeAwareTupleWriter(this.typeTraits, false, this.nullTypeTraits, this.nullIntrospector);
        BTreeFieldPrefixTupleReference prevTuple = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
        prevTuple.setFieldCount(fieldCount);
        BTreeFieldPrefixTupleReference tuple = new BTreeFieldPrefixTupleReference(tupleWriter.createTupleReference());
        tuple.setFieldCount(fieldCount);
        kp.firstTupleIndex = 0;
        int tupleCount = frame.getTupleCount();
        for (int i = 1; i < tupleCount; ++i) {
            prevTuple.resetByTupleIndex(frame, i - 1);
            tuple.resetByTupleIndex(frame, i);
            int prefixFieldsMatch = 0;
            for (int j = 0; j < maxCmps; ++j) {
                if (cmps[j].compare(pageArray, prevTuple.getFieldStart(j), prevTuple.getFieldLength(j), pageArray, tuple.getFieldStart(j), prevTuple.getFieldLength(j)) == 0) {
                    ++kp.pmi[j].matches;
                    int prefixBytes = tupleWriter.bytesRequired((ITupleReference)tuple, 0, ++prefixFieldsMatch);
                    int spaceBenefit = tupleWriter.bytesRequired((ITupleReference)tuple) - tupleWriter.bytesRequired((ITupleReference)tuple, prefixFieldsMatch, tuple.getFieldCount() - prefixFieldsMatch);
                    if (kp.pmi[j].matches == occurrenceThreshold) {
                        kp.pmi[j].prefixBytes += prefixBytes;
                        kp.pmi[j].spaceCost += prefixBytes + slotManager.getSlotSize();
                        ++kp.pmi[j].prefixSlotsNeeded;
                        kp.pmi[j].spaceBenefit += occurrenceThreshold * spaceBenefit;
                        continue;
                    }
                    if (kp.pmi[j].matches <= occurrenceThreshold) continue;
                    kp.pmi[j].spaceBenefit += spaceBenefit;
                    continue;
                }
                kp.pmi[j].matches = 1;
                break;
            }
            if (maxCmps <= 0 || prefixFieldsMatch != 0) continue;
            kp.lastTupleIndex = i - 1;
            if (kp.lastTupleIndex - kp.firstTupleIndex + 1 < occurrenceThreshold) {
                keyPartitions.remove(keyPartitions.size() - 1);
            }
            kp = new KeyPartition(maxCmps);
            keyPartitions.add(kp);
            kp.firstTupleIndex = i;
        }
        kp.lastTupleIndex = tupleCount - 1;
        if (kp.lastTupleIndex - kp.firstTupleIndex + 1 < occurrenceThreshold) {
            keyPartitions.remove(keyPartitions.size() - 1);
        }
        return keyPartitions;
    }

    private class SortByOriginalRank
    implements Comparator<KeyPartition> {
        private SortByOriginalRank() {
        }

        @Override
        public int compare(KeyPartition a, KeyPartition b) {
            return a.firstTupleIndex - b.firstTupleIndex;
        }
    }

    private class SortByHeuristic
    implements Comparator<KeyPartition> {
        private SortByHeuristic() {
        }

        @Override
        public int compare(KeyPartition a, KeyPartition b) {
            if (a.maxPmiIndex < 0) {
                if (b.maxPmiIndex < 0) {
                    return 0;
                }
                return 1;
            }
            if (b.maxPmiIndex < 0) {
                return -1;
            }
            float thisHeuristicVal = (float)a.maxBenefitMinusCost / (float)a.pmi[a.maxPmiIndex].prefixSlotsNeeded;
            float otherHeuristicVal = (float)b.maxBenefitMinusCost / (float)b.pmi[b.maxPmiIndex].prefixSlotsNeeded;
            if (thisHeuristicVal < otherHeuristicVal) {
                return 1;
            }
            if (thisHeuristicVal > otherHeuristicVal) {
                return -1;
            }
            return 0;
        }
    }

    private class KeyPartition {
        public int firstTupleIndex;
        public int lastTupleIndex;
        public PrefixMatchInfo[] pmi;
        public int maxBenefitMinusCost = 0;
        public int maxPmiIndex = -1;

        public KeyPartition(int numKeyFields) {
            this.pmi = new PrefixMatchInfo[numKeyFields];
            for (int i = 0; i < numKeyFields; ++i) {
                this.pmi[i] = new PrefixMatchInfo();
            }
        }
    }

    private class PrefixMatchInfo {
        public int matches = 1;
        public int spaceCost = 0;
        public int spaceBenefit = 0;
        public int prefixSlotsNeeded = 0;
        public int prefixBytes = 0;

        private PrefixMatchInfo() {
        }
    }
}

