/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.dataflow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class InputSplitsFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] splitBytes;
    private String splitClassName;

    public InputSplitsFactory(InputSplit[] splits) throws HyracksDataException {
        this.splitBytes = this.splitsToBytes(splits);
        this.splitClassName = splits.length > 0 ? splits[0].getClass().getName() : FileSplit.class.getName();
    }

    public InputSplit[] getSplits() throws HyracksDataException {
        return this.bytesToSplits(this.splitBytes);
    }

    private byte[] splitsToBytes(InputSplit[] splits) throws HyracksDataException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(splits.length);
            for (int i = 0; i < splits.length; ++i) {
                splits[i].write((DataOutput)dos);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private InputSplit[] bytesToSplits(byte[] bytes) throws HyracksDataException {
        try {
            Class<?> splitClass = Class.forName(this.splitClassName);
            Constructor<?>[] constructors = splitClass.getDeclaredConstructors();
            Constructor<?> defaultConstructor = null;
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                defaultConstructor = constructor;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bis);
            int size = dis.readInt();
            InputSplit[] splits = new InputSplit[size];
            for (int i = 0; i < size; ++i) {
                splits[i] = (InputSplit)defaultConstructor.newInstance(new Object[0]);
                splits[i].readFields((DataInput)dis);
            }
            dis.close();
            return splits;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

