/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.aws.AwsS3InputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.CleanupUtils;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3InputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new AwsS3InputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths());
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        List<S3Object> filesOnly;
        block12: {
            super.configure(ctx, configuration, warningCollector);
            ExternalDataUtils.validateIncludeExclude(configuration);
            AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = this.getIncludeExcludeMatchers();
            String container = configuration.get("container");
            S3Client s3Client = ExternalDataUtils.AwsS3.buildAwsS3Client(configuration);
            try {
                filesOnly = this.listS3Objects(s3Client, container, includeExcludeMatcher);
            }
            catch (S3Exception ex) {
                try {
                    if (ex.awsErrorDetails().errorCode().equals("NotImplemented")) {
                        filesOnly = this.oldApiListS3Objects(s3Client, container, includeExcludeMatcher);
                        break block12;
                    }
                    throw ex;
                }
                catch (SdkException ex2) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ex2.getMessage()});
                }
            }
            catch (SdkException ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ex.getMessage()});
            }
            finally {
                if (s3Client != null) {
                    CleanupUtils.close((AutoCloseable)s3Client, null);
                }
            }
        }
        if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
            Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
            warningCollector.warn(warning);
        }
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private List<S3Object> listS3Objects(S3Client s3Client, String container, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher) {
        String newMarker = null;
        ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
        ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(container);
        listObjectsBuilder.prefix(ExternalDataUtils.getPrefix(this.configuration));
        while (true) {
            ListObjectsV2Response listObjectsResponse = newMarker == null ? s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()) : s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.continuationToken(newMarker).build());
            this.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
            if (!listObjectsResponse.isTruncated().booleanValue()) break;
            newMarker = listObjectsResponse.nextContinuationToken();
        }
        return filesOnly;
    }

    private List<S3Object> oldApiListS3Objects(S3Client s3Client, String container, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher) {
        String newMarker = null;
        ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
        ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder().bucket(container);
        listObjectsBuilder.prefix(ExternalDataUtils.getPrefix(this.configuration));
        while (true) {
            ListObjectsResponse listObjectsResponse = newMarker == null ? s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.build()) : s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.marker(newMarker).build());
            this.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
            if (!listObjectsResponse.isTruncated().booleanValue()) break;
            newMarker = listObjectsResponse.nextMarker();
        }
        return filesOnly;
    }

    private void collectAndFilterFiles(List<S3Object> s3Objects, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<S3Object> filesOnly) {
        for (S3Object object : s3Objects) {
            if (object.key().endsWith("/") || !predicate.test(matchers, object.key())) continue;
            filesOnly.add(object);
        }
    }

    private void distributeWorkLoad(List<S3Object> fileObjects, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (S3Object object : fileObjects) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(object.key(), object.size());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

