/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hyracks.api.application.IStateDumpHandler;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;

public class AsterixStateDumpHandler
implements IStateDumpHandler {
    private final String nodeId;
    private final Path dumpPath;
    private final ILifeCycleComponentManager lccm;

    public AsterixStateDumpHandler(String nodeId, String dumpPath, ILifeCycleComponentManager lccm) {
        this.nodeId = nodeId;
        this.dumpPath = Paths.get(dumpPath, new String[0]);
        this.lccm = lccm;
    }

    public void dumpState(OutputStream os) throws IOException {
        this.dumpPath.toFile().mkdirs();
        File df = this.dumpPath.resolve(this.nodeId + "-" + System.currentTimeMillis() + ".dump").toFile();
        try (FileOutputStream fos = new FileOutputStream(df);){
            this.lccm.dumpState((OutputStream)fos);
        }
        os.write(df.getAbsolutePath().getBytes("UTF-8"));
    }
}

