/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.dataflow.data.nontagged.comparators.ABinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class OrderedBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    private final boolean ascending;
    private final IBinaryComparatorFactory factory;

    public OrderedBinaryComparatorFactory(IBinaryComparatorFactory factory, boolean ascending) {
        this.factory = factory;
        this.ascending = ascending;
    }

    public IBinaryComparator createBinaryComparator() {
        final IBinaryComparator bc = this.factory.createBinaryComparator();
        if (this.ascending) {
            return new ABinaryComparator(){

                @Override
                public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                    return bc.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                }
            };
        }
        return new ABinaryComparator(){

            @Override
            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                return -bc.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("factory", this.factory.toJson(registry));
        json.put("ascending", this.ascending);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        IBinaryComparatorFactory factory = (IBinaryComparatorFactory)registry.deserialize(json.get("factory"));
        return new OrderedBinaryComparatorFactory(factory, json.get("ascending").asBoolean());
    }
}

