/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import java.io.Serializable;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMapSupplier;

abstract class AbstractFieldRangePartitionComputerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RangeMapSupplier rangeMapSupplier;
    private final IBinaryComparatorFactory[] comparatorFactories;
    protected final SourceLocation sourceLoc;

    AbstractFieldRangePartitionComputerFactory(RangeMapSupplier rangeMapSupplier, IBinaryComparatorFactory[] comparatorFactories, SourceLocation sourceLoc) {
        this.rangeMapSupplier = rangeMapSupplier;
        this.comparatorFactories = comparatorFactories;
        this.sourceLoc = sourceLoc;
    }

    private IBinaryComparator[] createBinaryComparators() {
        IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        return comparators;
    }

    final class RangeMapPartitionComputer {
        private RangeMap rangeMap;
        private IBinaryComparator[] comparators;

        RangeMapPartitionComputer() {
        }

        protected void initialize(IHyracksTaskContext taskContext) throws HyracksDataException {
            this.rangeMap = AbstractFieldRangePartitionComputerFactory.this.rangeMapSupplier.getRangeMap(taskContext);
            if (this.rangeMap == null) {
                throw HyracksDataException.create((int)118, (SourceLocation)AbstractFieldRangePartitionComputerFactory.this.sourceLoc, (Serializable[])new Serializable[0]);
            }
            if (this.comparators == null) {
                this.comparators = AbstractFieldRangePartitionComputerFactory.this.createBinaryComparators();
            }
        }

        int partition(IFrameTupleAccessor accessor, int tIndex, int[] rangeFields, int nParts) throws HyracksDataException {
            int slotIndex = this.findRangeMapSlot(accessor, tIndex, rangeFields);
            return this.mapRangeMapSlotToPartition(slotIndex, nParts);
        }

        int exclusivePartition(IFrameTupleAccessor accessor, int tIndex, int[] rangeFields, int nParts) throws HyracksDataException {
            int slotIndex = this.findRangeMapExclusiveSlot(accessor, tIndex, rangeFields);
            return this.mapRangeMapSlotToPartition(slotIndex, nParts);
        }

        private int mapRangeMapSlotToPartition(int slotIndex, int nParts) {
            double rangesPerPart = 1.0;
            if (this.rangeMap.getSplitCount() + 1 > nParts) {
                rangesPerPart = ((double)this.rangeMap.getSplitCount() + 1.0) / (double)nParts;
            }
            return (int)Math.floor((double)slotIndex / rangesPerPart);
        }

        private int findRangeMapSlot(IFrameTupleAccessor accessor, int tIndex, int[] rangeFields) throws HyracksDataException {
            int slotIndex = 0;
            int n = this.rangeMap.getSplitCount();
            for (int slotNumber = 0; slotNumber < n; ++slotNumber) {
                int c = this.compareSlotAndFields(accessor, tIndex, rangeFields, slotNumber);
                if (c < 0) {
                    return slotIndex;
                }
                ++slotIndex;
            }
            return slotIndex;
        }

        private int findRangeMapExclusiveSlot(IFrameTupleAccessor accessor, int tIndex, int[] rangeFields) throws HyracksDataException {
            int slotIndex = 0;
            int n = this.rangeMap.getSplitCount();
            for (int slotNumber = 0; slotNumber < n; ++slotNumber) {
                int c = this.compareSlotAndFields(accessor, tIndex, rangeFields, slotNumber);
                if (c <= 0) {
                    return slotIndex;
                }
                ++slotIndex;
            }
            return slotIndex;
        }

        private int compareSlotAndFields(IFrameTupleAccessor accessor, int tIndex, int[] rangeFields, int slotNumber) throws HyracksDataException {
            int c = 0;
            int startOffset = accessor.getTupleStartOffset(tIndex);
            int slotLength = accessor.getFieldSlotsLength();
            for (int fieldNum = 0; fieldNum < this.comparators.length; ++fieldNum) {
                int fIdx = rangeFields[fieldNum];
                int fStart = accessor.getFieldStartOffset(tIndex, fIdx);
                int fEnd = accessor.getFieldEndOffset(tIndex, fIdx);
                c = this.comparators[fieldNum].compare(accessor.getBuffer().array(), startOffset + slotLength + fStart, fEnd - fStart, this.rangeMap.getByteArray(), this.rangeMap.getStartOffset(fieldNum, slotNumber), this.rangeMap.getLength(fieldNum, slotNumber));
                if (c == 0) continue;
                return c;
            }
            return c;
        }
    }

    abstract class AbstractFieldRangeMultiPartitionComputer
    extends AbstractFieldRangePartitionComputer
    implements ITupleMultiPartitionComputer {
        private BitSet result;

        AbstractFieldRangeMultiPartitionComputer(IHyracksTaskContext taskContext) {
            super(taskContext);
        }

        @Override
        public void initialize() throws HyracksDataException {
            super.initialize();
            if (this.result == null) {
                this.result = new BitSet();
            }
        }

        public final BitSet partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
            this.result.clear();
            if (nParts == 1) {
                this.result.set(0);
            } else {
                int pStart = this.computeStartPartition(accessor, tIndex, nParts);
                int pEnd = this.computeEndPartition(accessor, tIndex, nParts);
                this.result.set(pStart, pEnd + 1);
            }
            return this.result;
        }

        protected abstract int computeStartPartition(IFrameTupleAccessor var1, int var2, int var3) throws HyracksDataException;

        protected abstract int computeEndPartition(IFrameTupleAccessor var1, int var2, int var3) throws HyracksDataException;
    }

    abstract class AbstractFieldRangeSinglePartitionComputer
    extends AbstractFieldRangePartitionComputer
    implements ITuplePartitionComputer {
        AbstractFieldRangeSinglePartitionComputer(IHyracksTaskContext taskContext) {
            super(taskContext);
        }

        public final int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
            return nParts == 1 ? 0 : this.computePartition(accessor, tIndex, nParts);
        }

        protected abstract int computePartition(IFrameTupleAccessor var1, int var2, int var3) throws HyracksDataException;
    }

    private abstract class AbstractFieldRangePartitionComputer {
        final IHyracksTaskContext taskContext;
        final RangeMapPartitionComputer rangeMapPartitionComputer;

        private AbstractFieldRangePartitionComputer(IHyracksTaskContext taskContext) {
            this.taskContext = taskContext;
            this.rangeMapPartitionComputer = new RangeMapPartitionComputer();
        }

        public void initialize() throws HyracksDataException {
            this.rangeMapPartitionComputer.initialize(this.taskContext);
        }
    }
}

