/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class NestGroupByRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op2;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op1;
        if (subplan.getNestedPlans().size() != 1) {
            return false;
        }
        ILogicalPlan p = (ILogicalPlan)subplan.getNestedPlans().get(0);
        if (p.getRoots().size() != 1) {
            return false;
        }
        HashSet free = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, free);
        if (free.size() != 1) {
            return false;
        }
        LogicalVariable fVar = null;
        Iterator iterator = free.iterator();
        if (iterator.hasNext()) {
            LogicalVariable v;
            fVar = v = (LogicalVariable)iterator.next();
        }
        if ((op2 = (AbstractLogicalOperator)((Mutable)op1.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)op2;
        if (gby.getNestedPlans().size() != 1) {
            return false;
        }
        ILogicalPlan p2 = (ILogicalPlan)gby.getNestedPlans().get(0);
        if (p2.getRoots().size() != 1) {
            return false;
        }
        Mutable r2 = (Mutable)p2.getRoots().get(0);
        AbstractLogicalOperator opr2 = (AbstractLogicalOperator)r2.getValue();
        if (opr2.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggOuter = (AggregateOperator)opr2;
        int posInAggList = aggOuter.getVariables().indexOf(fVar);
        if (posInAggList < 0) {
            return false;
        }
        AbstractLogicalOperator outerAggSon = (AbstractLogicalOperator)((Mutable)aggOuter.getInputs().get(0)).getValue();
        if (outerAggSon.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        ILogicalExpression eAgg = (ILogicalExpression)((Mutable)aggOuter.getExpressions().get(posInAggList)).getValue();
        if (eAgg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression listifyCall = (AbstractFunctionCallExpression)eAgg;
        if (listifyCall.getFunctionIdentifier() != BuiltinFunctions.LISTIFY) {
            return false;
        }
        ILogicalExpression argListify = (ILogicalExpression)((Mutable)listifyCall.getArguments().get(0)).getValue();
        if (argListify.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        Mutable r = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator opInS = (AbstractLogicalOperator)r.getValue();
        if (opInS.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggInner = (AggregateOperator)opInS;
        while ((opInS = (AbstractLogicalOperator)((Mutable)opInS.getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.ASSIGN) {
        }
        if (opInS.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        AbstractLogicalOperator unnestParent = opInS;
        AbstractLogicalOperator opUnder = (AbstractLogicalOperator)((Mutable)opInS.getInputs().get(0)).getValue();
        while (opUnder.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            unnestParent = opUnder;
            opUnder = (AbstractLogicalOperator)((Mutable)opUnder.getInputs().get(0)).getValue();
        }
        if (opUnder.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)opUnder;
        AbstractLogicalOperator unnestSon = (AbstractLogicalOperator)((Mutable)unnest.getInputs().get(0)).getValue();
        if (unnestSon.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        NestedTupleSourceOperator innerNts = (NestedTupleSourceOperator)unnestSon;
        ILogicalExpression eUnnest = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (eUnnest.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression uf = (AbstractFunctionCallExpression)eUnnest;
        if (uf.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return false;
        }
        ILogicalExpression scanArg = (ILogicalExpression)((Mutable)uf.getArguments().get(0)).getValue();
        if (scanArg.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        if (((VariableReferenceExpression)scanArg).getVariableReference() != fVar) {
            return false;
        }
        LogicalVariable uVar = unnest.getVariable();
        GroupByOperator innerGby = (GroupByOperator)opInS;
        HashSet freeInInnerGby = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)innerGby, freeInInnerGby);
        for (LogicalVariable v : freeInInnerGby) {
            if (v == uVar) continue;
            return false;
        }
        ((Mutable)unnestParent.getInputs().get(0)).setValue((Object)innerNts);
        LogicalVariable listifiedVar = ((VariableReferenceExpression)argListify).getVariableReference();
        this.substInSubplan(aggInner, uVar, listifiedVar, context);
        gby.getNestedPlans().add(p);
        innerNts.getDataSourceReference().setValue((Object)gby);
        opRef.setValue((Object)gby);
        OperatorPropertiesUtil.typePlan((ILogicalPlan)p, (IOptimizationContext)context);
        OperatorPropertiesUtil.typePlan((ILogicalPlan)p2, (IOptimizationContext)context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gby);
        return true;
    }

    private void substInSubplan(AggregateOperator aggInner, LogicalVariable v1, LogicalVariable v2, IOptimizationContext context) throws AlgebricksException {
        AggregateOperator op = aggInner;
        while (op.getInputs().size() == 1) {
            VariableUtilities.substituteVariables((ILogicalOperator)op, (LogicalVariable)v1, (LogicalVariable)v2, (ITypingContext)context);
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
    }
}

