/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.model.io.stax.IndentingXMLStreamWriter;

public class AppassemblerModelStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, Daemon daemon) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(daemon.getModelEncoding(), "1.0");
        this.writeDaemon(daemon, "daemon", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, Daemon daemon) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, daemon.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(daemon.getModelEncoding(), "1.0");
        this.writeDaemon(daemon, "daemon", serializer);
        serializer.writeEndDocument();
    }

    private void writeClasspath(Classpath classpath, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (classpath != null) {
            serializer.writeStartElement(tagName);
            if (classpath.getDependencies() != null && classpath.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                for (Dependency dependency : classpath.getDependencies()) {
                    this.writeDependency(dependency, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            if (classpath.getDirectories() != null && classpath.getDirectories().size() > 0) {
                serializer.writeStartElement("directories");
                for (Directory directory : classpath.getDirectories()) {
                    this.writeDirectory(directory, "directory", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeClasspathElement(ClasspathElement classpathElement, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (classpathElement != null) {
            serializer.writeStartElement(tagName);
            if (classpathElement.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(classpathElement.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDaemon(Daemon daemon, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (daemon != null) {
            serializer.writeStartElement(tagName);
            if (daemon.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(daemon.getId());
                serializer.writeEndElement();
            }
            if (daemon.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(daemon.getName());
                serializer.writeEndElement();
            }
            if (daemon.getLongName() != null) {
                serializer.writeStartElement("longName");
                serializer.writeCharacters(daemon.getLongName());
                serializer.writeEndElement();
            }
            if (daemon.getMainClass() != null) {
                serializer.writeStartElement("mainClass");
                serializer.writeCharacters(daemon.getMainClass());
                serializer.writeEndElement();
            }
            if (daemon.getWrapperMainClass() != null && !daemon.getWrapperMainClass().equals("org.tanukisoftware.wrapper.WrapperSimpleApp")) {
                serializer.writeStartElement("wrapperMainClass");
                serializer.writeCharacters(daemon.getWrapperMainClass());
                serializer.writeEndElement();
            }
            if (daemon.getClasspath() != null) {
                this.writeClasspath(daemon.getClasspath(), "classpath", serializer);
            }
            if (daemon.getCommandLineArguments() != null && daemon.getCommandLineArguments().size() > 0) {
                serializer.writeStartElement("commandLineArguments");
                for (String commandLineArgument : daemon.getCommandLineArguments()) {
                    serializer.writeStartElement("commandLineArgument");
                    serializer.writeCharacters(commandLineArgument);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (daemon.getConfigurationDirectory() != null && !daemon.getConfigurationDirectory().equals("repo")) {
                serializer.writeStartElement("configurationDirectory");
                serializer.writeCharacters(daemon.getConfigurationDirectory());
                serializer.writeEndElement();
            }
            if (daemon.getJvmSettings() != null) {
                this.writeJvmSettings(daemon.getJvmSettings(), "jvmSettings", serializer);
            }
            if (daemon.getEnvironmentSetupFileName() != null) {
                serializer.writeStartElement("environmentSetupFileName");
                serializer.writeCharacters(daemon.getEnvironmentSetupFileName());
                serializer.writeEndElement();
            }
            if (!daemon.isShowConsoleWindow()) {
                serializer.writeStartElement("showConsoleWindow");
                serializer.writeCharacters(String.valueOf(daemon.isShowConsoleWindow()));
                serializer.writeEndElement();
            }
            if (!daemon.isUseTimestampInSnapshotFileName()) {
                serializer.writeStartElement("useTimestampInSnapshotFileName");
                serializer.writeCharacters(String.valueOf(daemon.isUseTimestampInSnapshotFileName()));
                serializer.writeEndElement();
            }
            if (daemon.isUseDaemonIdAsWrapperConfName()) {
                serializer.writeStartElement("useDaemonIdAsWrapperConfName");
                serializer.writeCharacters(String.valueOf(daemon.isUseDaemonIdAsWrapperConfName()));
                serializer.writeEndElement();
            }
            if (daemon.isUseDaemonIdAsWrapperExePrefixName()) {
                serializer.writeStartElement("useDaemonIdAsWrapperExePrefixName");
                serializer.writeCharacters(String.valueOf(daemon.isUseDaemonIdAsWrapperExePrefixName()));
                serializer.writeEndElement();
            }
            if (daemon.isUseWildcardClassPath()) {
                serializer.writeStartElement("useWildcardClassPath");
                serializer.writeCharacters(String.valueOf(daemon.isUseWildcardClassPath()));
                serializer.writeEndElement();
            }
            if (daemon.getGeneratorConfigurations() != null && daemon.getGeneratorConfigurations().size() > 0) {
                serializer.writeStartElement("generatorConfigurations");
                for (GeneratorConfiguration o : daemon.getGeneratorConfigurations()) {
                    this.writeGeneratorConfiguration(o, "generatorConfiguration", serializer);
                }
                serializer.writeEndElement();
            }
            if (daemon.getRepositoryName() != null && !daemon.getRepositoryName().equals("repo")) {
                serializer.writeStartElement("repositoryName");
                serializer.writeCharacters(daemon.getRepositoryName());
                serializer.writeEndElement();
            }
            if (daemon.getLicenseHeaderFile() != null) {
                serializer.writeStartElement("licenseHeaderFile");
                serializer.writeCharacters(daemon.getLicenseHeaderFile());
                serializer.writeEndElement();
            }
            if (daemon.getWrapperLogFile() != null) {
                serializer.writeStartElement("wrapperLogFile");
                serializer.writeCharacters(daemon.getWrapperLogFile());
                serializer.writeEndElement();
            }
            if (daemon.getUnixScriptTemplate() != null) {
                serializer.writeStartElement("unixScriptTemplate");
                serializer.writeCharacters(daemon.getUnixScriptTemplate());
                serializer.writeEndElement();
            }
            if (daemon.getWindowsScriptTemplate() != null) {
                serializer.writeStartElement("windowsScriptTemplate");
                serializer.writeCharacters(daemon.getWindowsScriptTemplate());
                serializer.writeEndElement();
            }
            if (daemon.getExternalDeltaPackDirectory() != null) {
                serializer.writeStartElement("externalDeltaPackDirectory");
                serializer.writeCharacters(daemon.getExternalDeltaPackDirectory());
                serializer.writeEndElement();
            }
            if (daemon.getEndorsedDir() != null) {
                serializer.writeStartElement("endorsedDir");
                serializer.writeCharacters(daemon.getEndorsedDir());
                serializer.writeEndElement();
            }
            if (daemon.getPreWrapperConf() != null) {
                serializer.writeStartElement("preWrapperConf");
                serializer.writeCharacters(daemon.getPreWrapperConf());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDependency(Dependency dependency, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependency != null) {
            serializer.writeStartElement(tagName);
            if (dependency.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(dependency.getGroupId());
                serializer.writeEndElement();
            }
            if (dependency.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(dependency.getArtifactId());
                serializer.writeEndElement();
            }
            if (dependency.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(dependency.getVersion());
                serializer.writeEndElement();
            }
            if (dependency.getClassifier() != null) {
                serializer.writeStartElement("classifier");
                serializer.writeCharacters(dependency.getClassifier());
                serializer.writeEndElement();
            }
            if (dependency.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(dependency.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDirectory(Directory directory, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (directory != null) {
            serializer.writeStartElement(tagName);
            if (directory.getRelativePath() != null) {
                serializer.writeStartElement("relativePath");
                serializer.writeCharacters(directory.getRelativePath());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeGeneratorConfiguration(GeneratorConfiguration generatorConfiguration, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (generatorConfiguration != null) {
            serializer.writeStartElement(tagName);
            if (generatorConfiguration.getGenerator() != null) {
                serializer.writeStartElement("generator");
                serializer.writeCharacters(generatorConfiguration.getGenerator());
                serializer.writeEndElement();
            }
            if (generatorConfiguration.getConfiguration() != null && generatorConfiguration.getConfiguration().size() > 0) {
                serializer.writeStartElement("configuration");
                for (String string : generatorConfiguration.getConfiguration().keySet()) {
                    String value = (String)generatorConfiguration.getConfiguration().get(string);
                    serializer.writeStartElement("" + string + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (generatorConfiguration.getIncludes() != null && generatorConfiguration.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                for (String string : generatorConfiguration.getIncludes()) {
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(string);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJvmSettings(JvmSettings jvmSettings, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jvmSettings != null) {
            serializer.writeStartElement(tagName);
            if (jvmSettings.getInitialMemorySize() != null) {
                serializer.writeStartElement("initialMemorySize");
                serializer.writeCharacters(jvmSettings.getInitialMemorySize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getMaxMemorySize() != null) {
                serializer.writeStartElement("maxMemorySize");
                serializer.writeCharacters(jvmSettings.getMaxMemorySize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getMaxStackSize() != null) {
                serializer.writeStartElement("maxStackSize");
                serializer.writeCharacters(jvmSettings.getMaxStackSize());
                serializer.writeEndElement();
            }
            if (jvmSettings.getSystemProperties() != null && jvmSettings.getSystemProperties().size() > 0) {
                serializer.writeStartElement("systemProperties");
                for (String systemProperty : jvmSettings.getSystemProperties()) {
                    serializer.writeStartElement("systemProperty");
                    serializer.writeCharacters(systemProperty);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (jvmSettings.getExtraArguments() != null && jvmSettings.getExtraArguments().size() > 0) {
                serializer.writeStartElement("extraArguments");
                for (String extraArgument : jvmSettings.getExtraArguments()) {
                    serializer.writeStartElement("extraArgument");
                    serializer.writeCharacters(extraArgument);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

