/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;

public class ResourceReference {
    protected String root;
    protected String partition;
    protected String dataverse;
    protected String dataset;
    protected String rebalance;
    protected String index;
    protected String name;

    protected ResourceReference() {
    }

    public static ResourceReference ofIndex(String indexPath) {
        return ResourceReference.of(new File(indexPath, ".metadata").toString());
    }

    public static ResourceReference of(String localResourcePath) {
        ResourceReference lrr = new ResourceReference();
        ResourceReference.parse(lrr, localResourcePath);
        return lrr;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getDataverse() {
        return this.dataverse;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getRebalance() {
        return this.rebalance;
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Path getRelativePath() {
        return Paths.get(this.root, this.partition, this.dataverse, this.dataset, this.rebalance, this.index);
    }

    public ResourceReference getDatasetReference() {
        return ResourceReference.ofIndex(Paths.get(this.root, this.partition, this.dataverse, this.dataset, this.rebalance, this.dataset).toFile().getPath());
    }

    public Path getFileRelativePath() {
        return Paths.get(this.root, this.partition, this.dataverse, this.dataset, this.rebalance, this.index, this.name);
    }

    protected static void parse(ResourceReference ref, String path) {
        String[] tokens = StringUtils.split((String)path, (char)File.separatorChar);
        if (tokens.length < 6) {
            throw new IllegalStateException("Unrecognized path structure: " + path);
        }
        int offset = tokens.length;
        ref.name = tokens[--offset];
        ref.index = tokens[--offset];
        ref.rebalance = tokens[--offset];
        ref.dataset = tokens[--offset];
        ref.dataverse = tokens[--offset];
        ref.partition = tokens[--offset];
        ref.root = tokens[--offset];
    }

    public int getPartitionNum() {
        return Integer.parseInt(this.partition.substring("partition_".length()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ResourceReference) {
            ResourceReference that = (ResourceReference)o;
            return this.getRelativePath().toString().equals(that.getRelativePath().toString());
        }
        return false;
    }

    public int hashCode() {
        return this.getRelativePath().toString().hashCode();
    }

    public String toString() {
        return this.getRelativePath().toString();
    }

    public static String getComponentSequence(String componentFile) {
        ResourceReference ref = ResourceReference.of(componentFile);
        return IndexComponentFileReference.of((String)ref.getName()).getSequence();
    }
}

