/* Optimized version. Draws a Julia picture. Check the code for variables
   to modify if you want other pictures. */

/* BUG BUG BUG. After I had compiled and linked the mag I noticed a
   small bug in the fractal text. It says that zrsqr = zr etc., but
   of course this should be zrsqr = zr. I don't want to waste half
   an hour compiling the mag all over when I can write it here
   instead. Hope you didn't get too confused... */

#include <graphics.h>

main()
{
  int g_driver = 9, g_mode = 2; /* VGA-16 col, 640x480 */
  int count, i;
  float r0, r1, i0, i1, zreal, zimag, zimag2, ztemp, zsize;
  float m, n, cr, ci, zrsqr, zisqr;

  /* Set up the graphics and colors. */

  initgraph(&g_driver, &g_mode, "");

  for(i = 0; i < 16; ++i)
  {
    setrgbpalette(i,0,i*2,i*4);
    setpalette(i,i);
  }

  /* Change these values for different parts of the current Julia Set. */

  r0 = -2.0; r1 = 2.0;
  i0 = 1.5; i1 = -1.5;

  /* Change these values for different Julia Sets. Check out JULIA.EXS for
     some examples. */

  cr = 0.32; ci = 0.043;

  for(n = 0; n < 480; ++n)
  {
    zimag2 = i0 + ((i1-i0)*n)/480;
    for(m = 0; m < 480; ++m)
    {
      zreal = r0 + ((r1-r0)*m)/480;
      zimag = zimag2;

      zrsqr = zreal*zreal;
      zisqr = zimag*zimag;

      for(count = zsize = 0; ((count < 256) && (zsize < 4.0)); ++count)
      {
        ztemp = zreal;
        zreal = zrsqr - zisqr + cr;
        zimag = 2*ztemp*zimag + ci;
        zrsqr = zreal*zreal;
        zisqr = zimag*zimag;
        zsize = zrsqr + zisqr;
      }

      if (count != 256)
      {
	if (count > 14) count = 15;
	  putpixel(m+80, n, count);
      }
      if (kbhit())
      {
        closegraph();
        return(0); /* Yes, close up and leave. */
      }
    }
  }
  /* Picture done. Wait for key, then shut down the graphics and leave
     the program. */
  getch();
  closegraph();
  return(0);
}

