//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 27th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.util.SparseArray;
import android.util.SparseBooleanArray;

public class ParagraphBlock {
	
	public static volatile SparseArray<ArrayList<String>> line = new SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Float>> width = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> height = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> depth = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> xpos = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<ArrayList<Float>> ypos = new SparseArray<ArrayList<Float>>(); 
	public static volatile SparseArray<ArrayList<String>> attribute = new SparseArray<ArrayList<String>>();
	public static volatile SparseArray<ArrayList<Float>> tlinelength = new SparseArray<ArrayList<Float>>();
	public static volatile SparseArray<Float> linelength = new SparseArray<Float>();
	public static volatile SparseBooleanArray newfirstline = new SparseBooleanArray();
	
	   public void init(int tid){
		   synchronized(this){
			line.put(tid,new ArrayList<String>());
			width.put(tid,new ArrayList<Float>());
			height.put(tid,new ArrayList<Float>());
			depth.put(tid,new ArrayList<Float>());
			xpos.put(tid,new ArrayList<Float>());
			ypos.put(tid,new ArrayList<Float>());
			attribute.put(tid,new ArrayList<String>());			
			tlinelength.put(tid,new ArrayList<Float>());
	}}
	   
   public void add(int tid, ArrayList<String> line2, ArrayList<Float> width2, ArrayList<Float> height2, ArrayList<Float> depth2, ArrayList<Float > xpos2
			   ,ArrayList<Float> ypos2, ArrayList<String> attribute2, ArrayList<Float> tlinelength2,Float linelength2,Boolean newfirstline2){
		   for (int i=0;i<=line2.size()-1;i++){
			   line.get(tid).add(line2.get(i));
			   width.get(tid).add(width2.get(i));
			   height.get(tid).add(height2.get(i));
			   depth.get(tid).add(depth2.get(i));
			   xpos.get(tid).add(xpos2.get(i));
			   ypos.get(tid).add(ypos2.get(i));
			   attribute.get(tid).add(attribute2.get(i));
			   tlinelength.get(tid).add(tlinelength2.get(i));
		   }
		   linelength.put(tid,linelength2);
		   newfirstline.put(tid, newfirstline2);
	   }
}
