/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.StringListFieldEditor;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class IndentationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_INDENTATION = 20;
    private static final int MIN_INDENTATION = 0;

    public IndentationPreferencePage() {
        super(1);
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        TexlipsePreferencePage.addSpacer(this.getFieldEditorParent());
        this.addField((FieldEditor)new BooleanFieldEditor("indent", TexlipsePlugin.getResourceString("preferenceIndentEnabledLabel"), this.getFieldEditorParent()));
        String message = TexlipsePlugin.getResourceString("preferenceIndentLevelLabel").replaceFirst("%1", "0").replaceFirst("%2", "20");
        final IntegerFieldEditor indentationWidth = new IntegerFieldEditor("indentLevel", message, this.getFieldEditorParent());
        indentationWidth.setValidateStrategy(0);
        indentationWidth.setValidRange(0, 20);
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("indentTabs")) {
            indentationWidth.setEnabled(false, this.getFieldEditorParent());
        }
        this.addField((FieldEditor)indentationWidth);
        BooleanFieldEditor indentationTabs = new BooleanFieldEditor("indentTabs", TexlipsePlugin.getResourceString("preferenceIndentTabsLabel"), this.getFieldEditorParent()){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                if (newValue) {
                    indentationWidth.setEnabled(false, IndentationPreferencePage.this.getFieldEditorParent());
                } else {
                    indentationWidth.setEnabled(true, IndentationPreferencePage.this.getFieldEditorParent());
                }
            }
        };
        this.addField((FieldEditor)indentationTabs);
        TexlipsePreferencePage.addSpacer(this.getFieldEditorParent());
        this.addField((FieldEditor)new StringListFieldEditor("indentEnvs", TexlipsePlugin.getResourceString("preferenceIndentEnvsLabel"), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

