#!/bin/sh

if test $# -lt 2; then
  echo "Usage: $0 <version> [<file> <file> ...]"
  exit 1
fi

temp=${TMPDIR-/tmp}/version$$

version=$1
shift

for f in "$@"; do
  sed "s/REPLACE-WITH-VERSION/$version/" <$f >$temp || exit 1
  if cmp -s $f $temp; then
    echo "$f: No REPLACE-WITH-VERSION."
    exit 1
  fi
  rm -f $f
  mv $temp $f
done

rm -f $temp
