/**
 * Authors: Frederik Leyvraz, David Degenhardt
 * License: GNU General Public License v3.0 only
 * Version: 1.0.1
 */

package ch.bfh.ti.latexindexer;

import java.io.IOException;
import java.util.List;

public interface Parser {

    /**
     * Parses the given document.
     * @return A List containing all the words extracted from the file.
     * @throws IOException If the file cannot be read from.
     */
    List<Word> parseDocument() throws IOException;
    void checkVersion() throws IOException;
}


