# Quantum Cube Model – LaTeX Package

Visualize quantum states and gate operations using the quantum cube model in LaTeX.

## Overview

The `quantumcubemodel` package provides simple LaTeX commands for creating intuitive cube-based diagrams to represent quantum states of 1, 2, or 3 qubits. 
Inspired by Prof. B. Just’s framework, it’s especially useful for teaching, presentations, and educational material in quantum computing.

## Breaking Changes in v0.2.0

**v0.2.0 introduces breaking changes compared to v0.1.0.**

> These changes result from a major redesign of the API to allow for more flexibility and future enhancements. 
While this means some existing code may need to be updated, the new API makes it easier to extend and customize functionality going forward.

## Features

- Cube diagrams for 1, 2, or 3-qubit quantum states
- Representation of complex amplitudes and phases
- Visual transitions for quantum gates:
  - Hadamard
  - Pauli-X / Y / Z
  - CNot
  - Toffoli (CCNot)
- exposing tikz canvas for extended usecases

## License

MIT License
© 2025 Cedric Schacht

## Author

Cedric Schacht

[cedric.schacht@dhbw-stuttgart.de](mailto:cedric.schacht@dhbw-stuttgart.de)

[https://github.com/CedricSchacht/quantumcubemodel](https://github.com/CedricSchacht/quantumcubemodel)