.\" Mac figures with Psfig - asf 09/06/91"
.TH MACTOTEX l
.NAME MacToTeX \- Including Mac Figures in TeX with Psfig

.SH SYNOPSIS
This man page gives a general method for including MacIntosh Figures
in a TeX or LaTeX document using the macro package Psfig.

.SH INTRODUCTION
.LP
The Macintosh computers use their own set of internal commands (`QuickDraw')
to store graphics.  When the Macintosh converts these commands to
.I PostScript
, it creates the 
.I PostScript
file using a set of non-standard definitions. 
Since these definitions are 
non-standard, it can be tricky to print Macintosh figures from other computers
since these other computers do not often know what these definitions are.
This document tries to give a simple (but not foolproof) method of
including Macintosh figures in TeX or LaTeX. NOTE: This document is to be
used in addition to the 
.I Psfig/TeX User's Guide

.SH CAPTURE THE FIGURE
.LP
There are several ways of capturing the 
.I PostScript
output of MacDraw or some
other Macintosh program. One way is by typing  
clover-F immediately after 
clicking `OK' on the print dialog box. The file is always called `PostScript'
and is left in the folder of the Macintosh application you are using.  
The file
may also be located in the `Spool Folder' in the `System Folder'.

.RS +.6i
If the Print Monitor program is running, it may not allow you to write the
file to disk.
In this case you must turn background printing off.  Go to the 
.I Chooser
desk accessory and click the `background printing off' box.
.RE

Newer printer dialogs have a box you can click on to send the
output to a disk (
.I PostScript
) file.
Also print the figure as you would normally.  You will need this later to
determine the `Bounding Box'.

.RS +.6i
If you are using the System 7.0 LaserWriter Dialog: The print
dialog that comes with System 7.0 has a box that allows you to print
the document to a 
.I PostScript
file.  Unfortunately, the entire LaserPrep file
is included along with the document. After you have transferred the file
to the computer with TeX on it (see below), run the program 
.I cleanps
to get rid of the unwanted LaserPrep info.
.RE

.SH TRANSFER THE FIGURE
.LP
Transfer the 
.I PostScript
file you made to a computer that has TeX\ on it.  You
may do this using the Telnet program (and ftp) on the Macintosh.

.SH FIND THE BOUNDING BOX
.LP
Unfortunately, Macintosh does not conform to the standard of
specifying the Bounding Box of the graphics it prints.  Therefore you
must determine the Bounding Box yourself.  Take the printout of the
figure you made in Step 1, and a ruler. Imagine the smallest
box that completely 
encloses the figure.  Now measure the left are right sides of the box
from the left edge of the paper.  Do 
the same for the top and bottom
sides from the bottom edge of the paper. 

.SH EDITING THE TeX FILE
.LP
Near the beginning of your TeX\ file (in addition to the
line \\input{psfig}, insert the command

.RS +.6i
\\special{header=lprep68.pro}
.RE

This file is a properly edited version of the Apple LaserPrep file that is
sent to the printer by the Macintosh. 

.RS +.6i
Note that the version number (68 in this case) must be the same
as the version of the LaserPrep file that the 
.I PostScript
file was created with.
Look at the 
.I PostScript
file and find the line that says `(AppleDict md)'.  The
number after this is the version of the LaserPrep file.  If this number
is 71, you would have to use the file `lprep71.pro' instead.
.RE 

Now where you want the figure to be included, insert the command

.RS +.6i
\\psfig{figure=filename,bbllx=#in,bblly=#in,bburx=#in,bbury=#in}
.RE

where the number (#) you insert after bbllx is the
left side of the Bounding Box,
bblly is the bottom, bburx
is the right side, and bbury is the top. This example shows the
box dimensions in inches (in). 

.SH PRINTING THE FILE
.LP
Use the program dvips to print the TeX\ file to the printer.  As
of this writting dvi2ps will not work with Macintosh figures.

.RS +.6i
The file should print out on any printer (not just an Apple LaserWriter).
If you have troubles printing a file, try 
turning off/on the printer to erase any incompatible commands.

As of this writing, non-resident fonts included in version 71 
.I PostScript
files
will not print on non-Apple printers (This is a bug in lprep71.pro).

If you still have trouble printing a figure
Use the 
.I cleanps 
program on each of your 
.I PostScript
figure files.  You
may also have to run 
.I cleanps 
with the -f option if your
file contains loaded (non-resident) fonts.
.RE

.SH FILES

lprep71.pro
.sp
psfig.tex
.sp
psfig.sty
.sp
cleanps

.SH AUTHORS
lprep71.pro was modified from the original Apple LaserPrep info by
Bernd Raichle, with slight modifications by Adam Fedor.  cleanps was written
by Adam Fedor (fedor@boulder.colorado.edu).

.SH SEE ALSO
.I Psfig/TeX User's Guide
 

