/*
 *			Modules for G3 FAX DATA encoder/decoder  Ver 1.3
 *
 *										written by SHIMA,  Aug. 1993
 *
 *      A bug is fixed #if EXTENDED			by Gohodoji, Oct. 1993
 *		A bug is fixed #if !LOW_TO_HIGH		by Nagahama, Oct. 1993
 *		A change in fax_writeheader() etc	by Gohodoji, Oct. 1993
 *
 *		#define	NOENCODE	<-  Cut modules for encoder
 *  	#define	NODECODE	<-  Cut modules for decoder
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<mem.h>
#include	"g3fax.h"

int MAX_X = MAX_A4X;

static unsigned char MASK[9] =
		{0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff};

#ifndef	NOENCODE
static unsigned char ROW[9] =
		{0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
#endif

#ifndef	NODECODE
static unsigned char SET[9] =
		{0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00};
#endif

static unsigned char bitget_bitbuf;			/* ݂ bit  			*/
static unsigned char *bitget_buf;			/* ݂ bufferʒu		*/

#ifndef	NOENCODE
static int bitget_count;					/* ݂ byte̗L bits	*/
#endif

#ifndef	NODECODE
static unsigned char *bitget_buf_read;		/* ̓ǂݍ݂ʒu	*/
static unsigned char *bitget_buf_end;		/* buffer̃f[^̍Ō	*/
static int bitget_skip;						/* ݂ bytëʒu		*/
static FILE *bitget_fp;						/* buffer ɓǂݍstream	*/
static long bitget_file_pos;		/* bitget_buf_endstreamł̈ʒu	*/
#endif


static unsigned char *bitout_buf;		/* o͗p line buffer			*/
static int bitout_count;				/* ݂ byte ̎c bit	*/

#ifndef	NOENCODE
static unsigned char bitout_bitbuf;		/* o͗p  byte obt@		*/
#endif

#ifndef	NODECODE
static unsigned char *bitout_buf_end;	/* o͗p line buffer ̍Ō	*/
#endif

#ifndef NOENCODE
/*-------------------------------------------------------------------------
								FAX encoder
                               -------------*/
static int white_run_length;
static int black_run_length;
static int top_bit_count;
static size_t bitout_bufcount;

#if	EXTENDED
#  define MAX_FAX_WIDTH	2623
#else
#  define MAX_FAX_WIDTH	1791
#endif

struct Starfax_header {
	char id[2];
	char version;
	char _[5];
	char FIF[4];
	char __[4];
} sf_myheader = {
	"SF",
	0x01,
	0x00,
	0x00,
	0x00,
};

struct encode	{
	int	data;
#if	SMALL_DATA
	unsigned char length;
#else
	int	length;
#endif
};

static struct encode white_count_list[]={

	0x00AC,      8,	/*    0 */
	0x0038,      6,	/*    1 */
	0x000E,      4,	/*    2 */
	0x0001,      4,	/*    3 */
	0x000D,      4,	/*    4 */
	0x0003,      4,	/*    5 */
	0x0007,      4,	/*    6 */
	0x000F,      4,	/*    7 */
	0x0019,      5,	/*    8 */
	0x0005,      5,	/*    9 */
	0x001C,      5,	/*   10 */
	0x0002,      5,	/*   11 */
	0x0004,      6,	/*   12 */
	0x0030,      6,	/*   13 */
	0x000B,      6,	/*   14 */
	0x002B,      6,	/*   15 */
	0x0015,      6,	/*   16 */
	0x0035,      6,	/*   17 */
	0x0072,      7,	/*   18 */
	0x0018,      7,	/*   19 */
	0x0008,      7,	/*   20 */
	0x0074,      7,	/*   21 */
	0x0060,      7,	/*   22 */
	0x0010,      7,	/*   23 */
	0x000A,      7,	/*   24 */
	0x006A,      7,	/*   25 */
	0x0064,      7,	/*   26 */
	0x0012,      7,	/*   27 */
	0x000C,      7,	/*   28 */
	0x0040,      8,	/*   29 */
	0x00C0,      8,	/*   30 */
	0x0058,      8,	/*   31 */
	0x00D8,      8,	/*   32 */
	0x0048,      8,	/*   33 */
	0x00C8,      8,	/*   34 */
	0x0028,      8,	/*   35 */
	0x00A8,      8,	/*   36 */
	0x0068,      8,	/*   37 */
	0x00E8,      8,	/*   38 */
	0x0014,      8,	/*   39 */
	0x0094,      8,	/*   40 */
	0x0054,      8,	/*   41 */
	0x00D4,      8,	/*   42 */
	0x0034,      8,	/*   43 */
	0x00B4,      8,	/*   44 */
	0x0020,      8,	/*   45 */
	0x00A0,      8,	/*   46 */
	0x0050,      8,	/*   47 */
	0x00D0,      8,	/*   48 */
	0x004A,      8,	/*   49 */
	0x00CA,      8,	/*   50 */
	0x002A,      8,	/*   51 */
	0x00AA,      8,	/*   52 */
	0x0024,      8,	/*   53 */
	0x00A4,      8,	/*   54 */
	0x001A,      8,	/*   55 */
	0x009A,      8,	/*   56 */
	0x005A,      8,	/*   57 */
	0x00DA,      8,	/*   58 */
	0x0052,      8,	/*   59 */
	0x00D2,      8,	/*   60 */
	0x004C,      8,	/*   61 */
	0x00CC,      8,	/*   62 */
	0x002C,      8,	/*   63 */

	0x001B,      5,	/*   64 */
	0x0009,      5,	/*  128 */
	0x003A,      6,	/*  192 */
	0x0076,      7,	/*  256 */
	0x006C,      8,	/*  320 */
	0x00EC,      8,	/*  384 */
	0x0026,      8,	/*  448 */
	0x00A6,      8,	/*  512 */
	0x0016,      8,	/*  576 */
	0x00E6,      8,	/*  640 */
	0x0066,      9,	/*  704 */
	0x0166,      9,	/*  768 */
	0x0096,      9,	/*  832 */
	0x0196,      9,	/*  896 */
	0x0056,      9,	/*  960 */
	0x0156,      9,	/* 1024 */
	0x00D6,      9,	/* 1088 */
	0x01D6,      9,	/* 1152 */
	0x0036,      9,	/* 1216 */
	0x0136,      9,	/* 1280 */
	0x00B6,      9,	/* 1344 */
	0x01B6,      9,	/* 1408 */
	0x0032,      9,	/* 1472 */
	0x0132,      9,	/* 1536 */
	0x00B2,      9,	/* 1600 */
	0x0006,      6,	/* 1664 */
	0x01B2,      9 	/* 1728 */
#if	EXTENDED
	,
	0x0080,     11,	/* 1792 */
	0x0180,     11,	/* 1856 */
	0x0580,     11,	/* 1920 */
	0x0480,     12,	/* 1984 */
	0x0C80,     12,	/* 2048 */
	0x0280,     12,	/* 2112 */
	0x0A80,     12,	/* 2176 */
	0x0680,     12,	/* 2240 */
	0x0E80,     12,	/* 2304 */
	0x0380,     12,	/* 2368 */
	0x0B80,     12,	/* 2432 */
	0x0780,     12,	/* 2496 */
	0x0F80,     12 	/* 2560 */
#endif
};

static struct encode black_count_list[]={

	0x03B0,     10,	/*    0 */
	0x0002,      3,	/*    1 */
	0x0003,      2,	/*    2 */
	0x0001,      2,	/*    3 */
	0x0006,      3,	/*    4 */
	0x000C,      4,	/*    5 */
	0x0004,      4,	/*    6 */
	0x0018,      5,	/*    7 */
	0x0028,      6,	/*    8 */
	0x0008,      6,	/*    9 */
	0x0010,      7,	/*   10 */
	0x0050,      7,	/*   11 */
	0x0070,      7,	/*   12 */
	0x0020,      8,	/*   13 */
	0x00E0,      8,	/*   14 */
	0x0030,      9,	/*   15 */
	0x03A0,     10,	/*   16 */
	0x0060,     10,	/*   17 */
	0x0040,     10,	/*   18 */
	0x0730,     11,	/*   19 */
	0x00B0,     11,	/*   20 */
	0x01B0,     11,	/*   21 */
	0x0760,     11,	/*   22 */
	0x00A0,     11,	/*   23 */
	0x0740,     11,	/*   24 */
	0x00C0,     11,	/*   25 */
	0x0530,     12,	/*   26 */
	0x0D30,     12,	/*   27 */
	0x0330,     12,	/*   28 */
	0x0B30,     12,	/*   29 */
	0x0160,     12,	/*   30 */
	0x0960,     12,	/*   31 */
	0x0560,     12,	/*   32 */
	0x0D60,     12,	/*   33 */
	0x04B0,     12,	/*   34 */
	0x0CB0,     12,	/*   35 */
	0x02B0,     12,	/*   36 */
	0x0AB0,     12,	/*   37 */
	0x06B0,     12,	/*   38 */
	0x0EB0,     12,	/*   39 */
	0x0360,     12,	/*   40 */
	0x0B60,     12,	/*   41 */
	0x05B0,     12,	/*   42 */
	0x0DB0,     12,	/*   43 */
	0x02A0,     12,	/*   44 */
	0x0AA0,     12,	/*   45 */
	0x06A0,     12,	/*   46 */
	0x0EA0,     12,	/*   47 */
	0x0260,     12,	/*   48 */
	0x0A60,     12,	/*   49 */
	0x04A0,     12,	/*   50 */
	0x0CA0,     12,	/*   51 */
	0x0240,     12,	/*   52 */
	0x0EC0,     12,	/*   53 */
	0x01C0,     12,	/*   54 */
	0x0E40,     12,	/*   55 */
	0x0140,     12,	/*   56 */
	0x01A0,     12,	/*   57 */
	0x09A0,     12,	/*   58 */
	0x0D40,     12,	/*   59 */
	0x0340,     12,	/*   60 */
	0x05A0,     12,	/*   61 */
	0x0660,     12,	/*   62 */
	0x0E60,     12,	/*   63 */

	0x03C0,     10,	/*   64 */
	0x0130,     12,	/*  128 */
	0x0930,     12,	/*  192 */
	0x0DA0,     12,	/*  256 */
	0x0CC0,     12,	/*  320 */
	0x02C0,     12,	/*  384 */
	0x0AC0,     12,	/*  448 */
	0x06C0,     13,	/*  512 */
	0x16C0,     13,	/*  576 */
	0x0A40,     13,	/*  640 */
	0x1A40,     13,	/*  704 */
	0x0640,     13,	/*  768 */
	0x1640,     13,	/*  832 */
	0x09C0,     13,	/*  896 */
	0x19C0,     13,	/*  960 */
	0x05C0,     13,	/* 1024 */
	0x15C0,     13,	/* 1088 */
	0x0DC0,     13,	/* 1152 */
	0x1DC0,     13,	/* 1216 */
	0x0940,     13,	/* 1280 */
	0x1940,     13,	/* 1344 */
	0x0540,     13,	/* 1408 */
	0x1540,     13,	/* 1472 */
	0x0B40,     13,	/* 1536 */
	0x1B40,     13,	/* 1600 */
	0x04C0,     13,	/* 1664 */
	0x14C0,     13 	/* 1728 */
#if	EXTENDED
	,
	0x0080,     11,	/* 1792 */
	0x0180,     11,	/* 1856 */
	0x0580,     11,	/* 1920 */
	0x0480,     12,	/* 1984 */
	0x0C80,     12,	/* 2048 */
	0x0280,     12,	/* 2112 */
	0x0A80,     12,	/* 2176 */
	0x0680,     12,	/* 2240 */
	0x0E80,     12,	/* 2304 */
	0x0380,     12,	/* 2368 */
	0x0B80,     12,	/* 2432 */
	0x0780,     12,	/* 2496 */
	0x0F80,     12 	/* 2560 */
#endif
};

/* --------------------------------------------------- */
static void bitoutinit(char *s)
{
	bitout_bufcount = 0;
	bitout_bitbuf = 0;
	bitout_count = 8;
	bitout_buf = (unsigned char*)s;
}

/* --------------------------------------------------- */
#if	OLD_VERSION
void fax_writeheader(FILE *fp, int mode)
{
	if (mode == FINE_MODE)	/* is fine? */
		sf_myheader.FIF[1] = 0x40;
	fwrite(&sf_myheader, sizeof sf_myheader, 1, fp);
}
#else
void fax_writeheader(struct fax_header *dast, FILE *fp)
{
	sf_myheader.FIF[1] = (dast->resolution == FINE_MODE) ? 0x40 : 0;
	sf_myheader.FIF[2] = (dast->width == WD_B4) ? 2 : 0;
	fwrite(&sf_myheader, sizeof sf_myheader, 1, fp);
}

void fax_checkheader(struct fax_header *dast, FILE *fp)
{
	struct Starfax_header thisheader;

	fread(&thisheader, sizeof thisheader, 1, fp);
	if (strcmp(thisheader.id, sf_myheader.id)) {
		dast->isfax = 0;
	} else {
		dast->isfax = 1;
		dast->resolution = (thisheader.FIF[1] & 0x40) ? 1 : 0;
		dast->width = (thisheader.FIF[2] & 2) ? WD_B4 : WD_A4;
	}
 }
#endif

void fax_writertc(FILE *fp)
{
	static unsigned char RTC[] = {
		0x00, 0x08, 0x80,
		0x00, 0x08, 0x80,
		0x00, 0x08, 0x80,
	};
	
	fwrite(RTC, sizeof RTC, 1, fp);
}

/* --------------------------------------------------- */
static void set_bitoutzero(void)
{
	bitout_bufcount++;
	if (bitout_count < 8)
		*bitout_buf++ = bitout_bitbuf;
	else
		*bitout_buf++ = 0;
}

static void set_white_encode(int);
static void set_black_encode(int);

static void set_bitcount(struct encode *pt)
{
	int	data, length;

	data = pt->data;
	length = pt->length;
	while( (length -= bitout_count) >= 0 ){
		*bitout_buf++ = ((data << (8 - bitout_count))|bitout_bitbuf);
		bitout_bitbuf = 0;
		bitout_bufcount++;
		data >>= bitout_count;
		bitout_count = 8;
	}
	bitout_bitbuf |= (data << (8 - bitout_count));
	bitout_count = -length;
}

static void set_white_encode(int count)
{
#if	BIG_DATA
	while (count >= 64){
		if(count <= MAX_FAX_WIDTH){
			set_bitcount((white_count_list + 63) + (count/64));
			break;
		}
		set_white_encode(MAX_FAX_WIDTH);
		set_black_encode(0);
		count -= MAX_FAX_WIDTH;
	}
#else
	if (count >= 64)
			set_bitcount((white_count_list + 63) + (count/64));
#endif
	set_bitcount(white_count_list + (count & 63) );
}

static void set_black_encode(int count)
{
#if	BIG_DATA
	while (count >= 64){
		if(count <= MAX_FAX_WIDTH){
			set_bitcount((black_count_list + 63) + (count/64));
			break;
		}
		set_black_encode(MAX_FAX_WIDTH);
		set_white_encode(0);
		count -= MAX_FAX_WIDTH;
	}
#else
	if (count >= 64)
		set_bitcount((black_count_list + 63) + (count/64));
#endif
	set_bitcount(black_count_list + (count & 63));
}

static void set_eol(void)
{
	static struct encode eol_code = {0x800,12};
	set_bitcount(&eol_code);
}

static void count_run_length(void)
{
							/* remaining bits in the current byte are white? */
	if (!(bitget_bitbuf &= MASK[bitget_count])){
		do{
			top_bit_count += 8;
												/* next byte is also white	*/
		} while(!(bitget_bitbuf = *bitget_buf++));
		bitget_count = 8;
	}
							/* current byte contains white and black bits 	*/
	while(!(bitget_bitbuf & ROW[bitget_count]))
		bitget_count--;									/* skip white bits 	*/
	white_run_length = top_bit_count - (black_run_length = bitget_count);

						/* remaining bits in the current byte are black?	*/
	if (bitget_bitbuf == MASK[bitget_count]){
		do{
			black_run_length += 8;
												/* next byte is also black	*/
		} while((bitget_bitbuf = *bitget_buf++) == 0xff);
		bitget_count = 8;
	}
	else bitget_count--;						/* skip the top black bit	*/

							/* current byte contains white and black bits 	*/
	while(bitget_bitbuf & ROW[bitget_count])
		bitget_count--;							/* skip black bits	 		*/
	black_run_length -= (top_bit_count = bitget_count);
}

#if	TOP_BIT_SKIP
size_t fax_encode_tline(char *dast, char *src, int left, int right, int top)
#  define TOP top
#else
size_t fax_encode_line(char *dast, char *src, int left, int right)
#  define TOP  8
#endif
{
	int allruns;
	int	max_x;
#if	RECOVER
	char *src_end;
	unsigned char keep;

	max_x = MAX_X - right;
	keep = *(src_end = src + (max_x - left + (15 - TOP))/8);
	*src_end = 0xaa;				/* black, white, black, white, ... */
#else
	max_x = MAX_X - right;
	src[(max_x - left + (15 - TOP))/8] = 0xaa;
#endif
	bitget_buf    = (unsigned char*)src;
	bitget_bitbuf = *bitget_buf++;
	bitget_count  = TOP;
	top_bit_count = left + TOP;

	bitoutinit(dast);
	set_eol();
	allruns = 0;
	for(;;){
		count_run_length();
		if((allruns += white_run_length) < max_x)
			set_white_encode(white_run_length);
		else{
			set_white_encode(white_run_length + MAX_X - allruns);
			break;
		}
		if((allruns += black_run_length) < max_x)
			set_black_encode(black_run_length);
		else{
			set_black_encode(black_run_length + max_x - allruns);
			if (right > 0)
				set_white_encode(right);
			break;
		}
	}
	set_bitoutzero();
#if	RECOVER
	*src_end = keep;
#endif
	return bitout_bufcount;
}

#endif
#ifndef	NODECODE
/*-------------------------------------------------------------------------
								FAX decoder
                               ------------*/

static int f_MAKE;							/* MAKE UP Code ߒ?		*/
static int f_EOF;							/* f[^ׂēǂ?	*/
static char *faxbuf;

#define	MAX_X_BYTE	(MAX_X/8)

static int skip_eol(void);

static struct decode {
	int run;
#if	SMALL_DATA
	unsigned char length;
#else
	int length;
#endif
};

static struct decode white_decode_list[] = {

	{0x7fff,8},	/* 000 */
	{   3,  4},	/* 001 */
	{  11,  5},	/* 002 */
	{   5,  4},	/* 003 */
	{  12,  6},	/* 004 */
	{   9,  5},	/* 005 */
	{1664,  6},	/* 006 */
	{   6,  4},	/* 007 */
	{  20,  7},	/* 008 */
	{ 128,  5},	/* 009 */
	{  24,  7},	/* 00A */
	{  14,  6},	/* 00B */
	{  28,  7},	/* 00C */
	{   4,  4},	/* 00D */
	{   2,  4},	/* 00E */
	{   7,  4},	/* 00F */
	{  23,  7},	/* 010 */
	{   3,  4},	/* 011 */
	{  27,  7},	/* 012 */
	{   5,  4},	/* 013 */
	{  39,  8},	/* 014 */
	{  16,  6},	/* 015 */
	{ 576,  8},	/* 016 */
	{   6,  4},	/* 017 */
	{  19,  7},	/* 018 */
	{   8,  5},	/* 019 */
	{  55,  8},	/* 01A */
	{  64,  5},	/* 01B */
	{  10,  5},	/* 01C */
	{   4,  4},	/* 01D */
	{   2,  4},	/* 01E */
	{   7,  4},	/* 01F */
	{  45,  8},	/* 020 */
	{   3,  4},	/* 021 */
	{  11,  5},	/* 022 */
	{   5,  4},	/* 023 */
	{  53,  8},	/* 024 */
	{   9,  5},	/* 025 */
	{ 448,  8},	/* 026 */
	{   6,  4},	/* 027 */
	{  35,  8},	/* 028 */
	{ 128,  5},	/* 029 */
	{  51,  8},	/* 02A */
	{  15,  6},	/* 02B */
	{  63,  8},	/* 02C */
	{   4,  4},	/* 02D */
	{   2,  4},	/* 02E */
	{   7,  4},	/* 02F */
	{  13,  6},	/* 030 */
	{   3,  4},	/* 031 */
	{ 268,  9},	/* 032 */
	{   5,  4},	/* 033 */
	{  43,  8},	/* 034 */
	{  17,  6},	/* 035 */
	{ 264,  9},	/* 036 */
	{   6,  4},	/* 037 */
	{   1,  6},	/* 038 */
	{   8,  5},	/* 039 */
	{ 192,  6},	/* 03A */
	{  64,  5},	/* 03B */
	{  10,  5},	/* 03C */
	{   4,  4},	/* 03D */
	{   2,  4},	/* 03E */
	{   7,  4},	/* 03F */
	{  29,  8},	/* 040 */
	{   3,  4},	/* 041 */
	{  11,  5},	/* 042 */
	{   5,  4},	/* 043 */
	{  12,  6},	/* 044 */
	{   9,  5},	/* 045 */
	{1664,  6},	/* 046 */
	{   6,  4},	/* 047 */
	{  33,  8},	/* 048 */
	{ 128,  5},	/* 049 */
	{  49,  8},	/* 04A */
	{  14,  6},	/* 04B */
	{  61,  8},	/* 04C */
	{   4,  4},	/* 04D */
	{   2,  4},	/* 04E */
	{   7,  4},	/* 04F */
	{  47,  8},	/* 050 */
	{   3,  4},	/* 051 */
	{  59,  8},	/* 052 */
	{   5,  4},	/* 053 */
	{  41,  8},	/* 054 */
	{  16,  6},	/* 055 */
	{ 260,  9},	/* 056 */
	{   6,  4},	/* 057 */
	{  31,  8},	/* 058 */
	{   8,  5},	/* 059 */
	{  57,  8},	/* 05A */
	{  64,  5},	/* 05B */
	{  10,  5},	/* 05C */
	{   4,  4},	/* 05D */
	{   2,  4},	/* 05E */
	{   7,  4},	/* 05F */
	{  22,  7},	/* 060 */
	{   3,  4},	/* 061 */
	{  11,  5},	/* 062 */
	{   5,  4},	/* 063 */
	{  26,  7},	/* 064 */
	{   9,  5},	/* 065 */
	{ 256,  9},	/* 066 */
	{   6,  4},	/* 067 */
	{  37,  8},	/* 068 */
	{ 128,  5},	/* 069 */
	{  25,  7},	/* 06A */
	{  15,  6},	/* 06B */
	{ 320,  8},	/* 06C */
	{   4,  4},	/* 06D */
	{   2,  4},	/* 06E */
	{   7,  4},	/* 06F */
	{  13,  6},	/* 070 */
	{   3,  4},	/* 071 */
	{  18,  7},	/* 072 */
	{   5,  4},	/* 073 */
	{  21,  7},	/* 074 */
	{  17,  6},	/* 075 */
	{ 256,  7},	/* 076 */
	{   6,  4},	/* 077 */
	{   1,  6},	/* 078 */
	{   8,  5},	/* 079 */
	{ 192,  6},	/* 07A */
	{  64,  5},	/* 07B */
	{  10,  5},	/* 07C */
	{   4,  4},	/* 07D */
	{   2,  4},	/* 07E */
	{   7,  4},	/* 07F */
	{ 272, 12},	/* 080 */
	{   3,  4},	/* 081 */
	{  11,  5},	/* 082 */
	{   5,  4},	/* 083 */
	{  12,  6},	/* 084 */
	{   9,  5},	/* 085 */
	{1664,  6},	/* 086 */
	{   6,  4},	/* 087 */
	{  20,  7},	/* 088 */
	{ 128,  5},	/* 089 */
	{  24,  7},	/* 08A */
	{  14,  6},	/* 08B */
	{  28,  7},	/* 08C */
	{   4,  4},	/* 08D */
	{   2,  4},	/* 08E */
	{   7,  4},	/* 08F */
	{  23,  7},	/* 090 */
	{   3,  4},	/* 091 */
	{  27,  7},	/* 092 */
	{   5,  4},	/* 093 */
	{  40,  8},	/* 094 */
	{  16,  6},	/* 095 */
	{ 258,  9},	/* 096 */
	{   6,  4},	/* 097 */
	{  19,  7},	/* 098 */
	{   8,  5},	/* 099 */
	{  56,  8},	/* 09A */
	{  64,  5},	/* 09B */
	{  10,  5},	/* 09C */
	{   4,  4},	/* 09D */
	{   2,  4},	/* 09E */
	{   7,  4},	/* 09F */
	{  46,  8},	/* 0A0 */
	{   3,  4},	/* 0A1 */
	{  11,  5},	/* 0A2 */
	{   5,  4},	/* 0A3 */
	{  54,  8},	/* 0A4 */
	{   9,  5},	/* 0A5 */
	{ 512,  8},	/* 0A6 */
	{   6,  4},	/* 0A7 */
	{  36,  8},	/* 0A8 */
	{ 128,  5},	/* 0A9 */
	{  52,  8},	/* 0AA */
	{  15,  6},	/* 0AB */
	{   0,  8},	/* 0AC */
	{   4,  4},	/* 0AD */
	{   2,  4},	/* 0AE */
	{   7,  4},	/* 0AF */
	{  13,  6},	/* 0B0 */
	{   3,  4},	/* 0B1 */
	{ 270,  9},	/* 0B2 */
	{   5,  4},	/* 0B3 */
	{  44,  8},	/* 0B4 */
	{  17,  6},	/* 0B5 */
	{ 266,  9},	/* 0B6 */
	{   6,  4},	/* 0B7 */
	{   1,  6},	/* 0B8 */
	{   8,  5},	/* 0B9 */
	{ 192,  6},	/* 0BA */
	{  64,  5},	/* 0BB */
	{  10,  5},	/* 0BC */
	{   4,  4},	/* 0BD */
	{   2,  4},	/* 0BE */
	{   7,  4},	/* 0BF */
	{  30,  8},	/* 0C0 */
	{   3,  4},	/* 0C1 */
	{  11,  5},	/* 0C2 */
	{   5,  4},	/* 0C3 */
	{  12,  6},	/* 0C4 */
	{   9,  5},	/* 0C5 */
	{1664,  6},	/* 0C6 */
	{   6,  4},	/* 0C7 */
	{  34,  8},	/* 0C8 */
	{ 128,  5},	/* 0C9 */
	{  50,  8},	/* 0CA */
	{  14,  6},	/* 0CB */
	{  62,  8},	/* 0CC */
	{   4,  4},	/* 0CD */
	{   2,  4},	/* 0CE */
	{   7,  4},	/* 0CF */
	{  48,  8},	/* 0D0 */
	{   3,  4},	/* 0D1 */
	{  60,  8},	/* 0D2 */
	{   5,  4},	/* 0D3 */
	{  42,  8},	/* 0D4 */
	{  16,  6},	/* 0D5 */
	{ 262,  9},	/* 0D6 */
	{   6,  4},	/* 0D7 */
	{  32,  8},	/* 0D8 */
	{   8,  5},	/* 0D9 */
	{  58,  8},	/* 0DA */
	{  64,  5},	/* 0DB */
	{  10,  5},	/* 0DC */
	{   4,  4},	/* 0DD */
	{   2,  4},	/* 0DE */
	{   7,  4},	/* 0DF */
	{  22,  7},	/* 0E0 */
	{   3,  4},	/* 0E1 */
	{  11,  5},	/* 0E2 */
	{   5,  4},	/* 0E3 */
	{  26,  7},	/* 0E4 */
	{   9,  5},	/* 0E5 */
	{ 640,  8},	/* 0E6 */
	{   6,  4},	/* 0E7 */
	{  38,  8},	/* 0E8 */
	{ 128,  5},	/* 0E9 */
	{  25,  7},	/* 0EA */
	{  15,  6},	/* 0EB */
	{ 384,  8},	/* 0EC */
	{   4,  4},	/* 0ED */
	{   2,  4},	/* 0EE */
	{   7,  4},	/* 0EF */
	{  13,  6},	/* 0F0 */
	{   3,  4},	/* 0F1 */
	{  18,  7},	/* 0F2 */
	{   5,  4},	/* 0F3 */
	{  21,  7},	/* 0F4 */
	{  17,  6},	/* 0F5 */
	{ 256,  7},	/* 0F6 */
	{   6,  4},	/* 0F7 */
	{   1,  6},	/* 0F8 */
	{   8,  5},	/* 0F9 */
	{ 192,  6},	/* 0FA */
	{  64,  5},	/* 0FB */
	{  10,  5},	/* 0FC */
	{   4,  4},	/* 0FD */
	{   2,  4},	/* 0FE */
	{   7,  4},	/* 0FF */
	{ 704,  1},	/* 100 */
	{ 768,  1},	/* 101 */
	{ 832,  1},	/* 102 */
	{ 896,  1},	/* 103 */
	{ 960,  1},	/* 104 */
	{1024,  1},	/* 105 */
	{1088,  1},	/* 106 */
	{1152,  1},	/* 107 */
	{1216,  1},	/* 108 */
	{1280,  1},	/* 109 */
	{1344,  1},	/* 10A */
	{1408,  1},	/* 10B */
	{1472,  1},	/* 10C */
	{1536,  1},	/* 10D */
	{1600,  1},	/* 10E */
	{1728,  1},	/* 10F */
	{1792,  3},	/* 110 */
	{1856,  3},	/* 111 */
	{2112,  4},	/* 112 */
	{2368,  4},	/* 113 */
	{1984,  4},	/* 114 */
	{1920,  3},	/* 115 */
	{2240,  4},	/* 116 */
	{2496,  4},	/* 117 */
	{1792,  3},	/* 118 */
	{1856,  3},	/* 119 */
	{2176,  4},	/* 11A */
	{2432,  4},	/* 11B */
	{2048,  4},	/* 11C */
	{1920,  3},	/* 11D */
	{2304,  4},	/* 11E */
	{2560,  4} 	/* 11F */
};

static struct decode black_decode_list[] = {

	{0x7fff,8},	/* 000 */
	{   3,  2},	/* 001 */
	{   1,  3},	/* 002 */
	{   2,  2},	/* 003 */
	{   6,  4},	/* 004 */
	{   3,  2},	/* 005 */
	{   4,  3},	/* 006 */
	{   2,  2},	/* 007 */
	{   9,  6},	/* 008 */
	{   3,  2},	/* 009 */
	{   1,  3},	/* 00A */
	{   2,  2},	/* 00B */
	{   5,  4},	/* 00C */
	{   3,  2},	/* 00D */
	{   4,  3},	/* 00E */
	{   2,  2},	/* 00F */
	{  10,  7},	/* 010 */
	{   3,  2},	/* 011 */
	{   1,  3},	/* 012 */
	{   2,  2},	/* 013 */
	{   6,  4},	/* 014 */
	{   3,  2},	/* 015 */
	{   4,  3},	/* 016 */
	{   2,  2},	/* 017 */
	{   7,  5},	/* 018 */
	{   3,  2},	/* 019 */
	{   1,  3},	/* 01A */
	{   2,  2},	/* 01B */
	{   5,  4},	/* 01C */
	{   3,  2},	/* 01D */
	{   4,  3},	/* 01E */
	{   2,  2},	/* 01F */
	{  13,  8},	/* 020 */
	{   3,  2},	/* 021 */
	{   1,  3},	/* 022 */
	{   2,  2},	/* 023 */
	{   6,  4},	/* 024 */
	{   3,  2},	/* 025 */
	{   4,  3},	/* 026 */
	{   2,  2},	/* 027 */
	{   8,  6},	/* 028 */
	{   3,  2},	/* 029 */
	{   1,  3},	/* 02A */
	{   2,  2},	/* 02B */
	{   5,  4},	/* 02C */
	{   3,  2},	/* 02D */
	{   4,  3},	/* 02E */
	{   2,  2},	/* 02F */
	{ 272, 12},	/* 030 */
	{   3,  2},	/* 031 */
	{   1,  3},	/* 032 */
	{   2,  2},	/* 033 */
	{   6,  4},	/* 034 */
	{   3,  2},	/* 035 */
	{   4,  3},	/* 036 */
	{   2,  2},	/* 037 */
	{   7,  5},	/* 038 */
	{   3,  2},	/* 039 */
	{   1,  3},	/* 03A */
	{   2,  2},	/* 03B */
	{   5,  4},	/* 03C */
	{   3,  2},	/* 03D */
	{   4,  3},	/* 03E */
	{   2,  2},	/* 03F */
	{ 320, 13},	/* 040 */
	{   3,  2},	/* 041 */
	{   1,  3},	/* 042 */
	{   2,  2},	/* 043 */
	{   6,  4},	/* 044 */
	{   3,  2},	/* 045 */
	{   4,  3},	/* 046 */
	{   2,  2},	/* 047 */
	{   9,  6},	/* 048 */
	{   3,  2},	/* 049 */
	{   1,  3},	/* 04A */
	{   2,  2},	/* 04B */
	{   5,  4},	/* 04C */
	{   3,  2},	/* 04D */
	{   4,  3},	/* 04E */
	{   2,  2},	/* 04F */
	{  11,  7},	/* 050 */
	{   3,  2},	/* 051 */
	{   1,  3},	/* 052 */
	{   2,  2},	/* 053 */
	{   6,  4},	/* 054 */
	{   3,  2},	/* 055 */
	{   4,  3},	/* 056 */
	{   2,  2},	/* 057 */
	{   7,  5},	/* 058 */
	{   3,  2},	/* 059 */
	{   1,  3},	/* 05A */
	{   2,  2},	/* 05B */
	{   5,  4},	/* 05C */
	{   3,  2},	/* 05D */
	{   4,  3},	/* 05E */
	{   2,  2},	/* 05F */
	{ 304, 12},	/* 060 */
	{   3,  2},	/* 061 */
	{   1,  3},	/* 062 */
	{   2,  2},	/* 063 */
	{   6,  4},	/* 064 */
	{   3,  2},	/* 065 */
	{   4,  3},	/* 066 */
	{   2,  2},	/* 067 */
	{   8,  6},	/* 068 */
	{   3,  2},	/* 069 */
	{   1,  3},	/* 06A */
	{   2,  2},	/* 06B */
	{   5,  4},	/* 06C */
	{   3,  2},	/* 06D */
	{   4,  3},	/* 06E */
	{   2,  2},	/* 06F */
	{  12,  7},	/* 070 */
	{   3,  2},	/* 071 */
	{   1,  3},	/* 072 */
	{   2,  2},	/* 073 */
	{   6,  4},	/* 074 */
	{   3,  2},	/* 075 */
	{   4,  3},	/* 076 */
	{   2,  2},	/* 077 */
	{   7,  5},	/* 078 */
	{   3,  2},	/* 079 */
	{   1,  3},	/* 07A */
	{   2,  2},	/* 07B */
	{   5,  4},	/* 07C */
	{   3,  2},	/* 07D */
	{   4,  3},	/* 07E */
	{   2,  2},	/* 07F */
	{ 384, 12},	/* 080 */
	{   3,  2},	/* 081 */
	{   1,  3},	/* 082 */
	{   2,  2},	/* 083 */
	{   6,  4},	/* 084 */
	{   3,  2},	/* 085 */
	{   4,  3},	/* 086 */
	{   2,  2},	/* 087 */
	{   9,  6},	/* 088 */
	{   3,  2},	/* 089 */
	{   1,  3},	/* 08A */
	{   2,  2},	/* 08B */
	{   5,  4},	/* 08C */
	{   3,  2},	/* 08D */
	{   4,  3},	/* 08E */
	{   2,  2},	/* 08F */
	{  10,  7},	/* 090 */
	{   3,  2},	/* 091 */
	{   1,  3},	/* 092 */
	{   2,  2},	/* 093 */
	{   6,  4},	/* 094 */
	{   3,  2},	/* 095 */
	{   4,  3},	/* 096 */
	{   2,  2},	/* 097 */
	{   7,  5},	/* 098 */
	{   3,  2},	/* 099 */
	{   1,  3},	/* 09A */
	{   2,  2},	/* 09B */
	{   5,  4},	/* 09C */
	{   3,  2},	/* 09D */
	{   4,  3},	/* 09E */
	{   2,  2},	/* 09F */
	{ 288, 12},	/* 0A0 */
	{   3,  2},	/* 0A1 */
	{   1,  3},	/* 0A2 */
	{   2,  2},	/* 0A3 */
	{   6,  4},	/* 0A4 */
	{   3,  2},	/* 0A5 */
	{   4,  3},	/* 0A6 */
	{   2,  2},	/* 0A7 */
	{   8,  6},	/* 0A8 */
	{   3,  2},	/* 0A9 */
	{   1,  3},	/* 0AA */
	{   2,  2},	/* 0AB */
	{   5,  4},	/* 0AC */
	{   3,  2},	/* 0AD */
	{   4,  3},	/* 0AE */
	{   2,  2},	/* 0AF */
	{ 256, 12},	/* 0B0 */
	{   3,  2},	/* 0B1 */
	{   1,  3},	/* 0B2 */
	{   2,  2},	/* 0B3 */
	{   6,  4},	/* 0B4 */
	{   3,  2},	/* 0B5 */
	{   4,  3},	/* 0B6 */
	{   2,  2},	/* 0B7 */
	{   7,  5},	/* 0B8 */
	{   3,  2},	/* 0B9 */
	{   1,  3},	/* 0BA */
	{   2,  2},	/* 0BB */
	{   5,  4},	/* 0BC */
	{   3,  2},	/* 0BD */
	{   4,  3},	/* 0BE */
	{   2,  2},	/* 0BF */
	{ 352, 13},	/* 0C0 */
	{   3,  2},	/* 0C1 */
	{   1,  3},	/* 0C2 */
	{   2,  2},	/* 0C3 */
	{   6,  4},	/* 0C4 */
	{   3,  2},	/* 0C5 */
	{   4,  3},	/* 0C6 */
	{   2,  2},	/* 0C7 */
	{   9,  6},	/* 0C8 */
	{   3,  2},	/* 0C9 */
	{   1,  3},	/* 0CA */
	{   2,  2},	/* 0CB */
	{   5,  4},	/* 0CC */
	{   3,  2},	/* 0CD */
	{   4,  3},	/* 0CE */
	{   2,  2},	/* 0CF */
	{  11,  7},	/* 0D0 */
	{   3,  2},	/* 0D1 */
	{   1,  3},	/* 0D2 */
	{   2,  2},	/* 0D3 */
	{   6,  4},	/* 0D4 */
	{   3,  2},	/* 0D5 */
	{   4,  3},	/* 0D6 */
	{   2,  2},	/* 0D7 */
	{   7,  5},	/* 0D8 */
	{   3,  2},	/* 0D9 */
	{   1,  3},	/* 0DA */
	{   2,  2},	/* 0DB */
	{   5,  4},	/* 0DC */
	{   3,  2},	/* 0DD */
	{   4,  3},	/* 0DE */
	{   2,  2},	/* 0DF */
	{  14,  8},	/* 0E0 */
	{   3,  2},	/* 0E1 */
	{   1,  3},	/* 0E2 */
	{   2,  2},	/* 0E3 */
	{   6,  4},	/* 0E4 */
	{   3,  2},	/* 0E5 */
	{   4,  3},	/* 0E6 */
	{   2,  2},	/* 0E7 */
	{   8,  6},	/* 0E8 */
	{   3,  2},	/* 0E9 */
	{   1,  3},	/* 0EA */
	{   2,  2},	/* 0EB */
	{   5,  4},	/* 0EC */
	{   3,  2},	/* 0ED */
	{   4,  3},	/* 0EE */
	{   2,  2},	/* 0EF */
	{  12,  7},	/* 0F0 */
	{   3,  2},	/* 0F1 */
	{   1,  3},	/* 0F2 */
	{   2,  2},	/* 0F3 */
	{   6,  4},	/* 0F4 */
	{   3,  2},	/* 0F5 */
	{   4,  3},	/* 0F6 */
	{   2,  2},	/* 0F7 */
	{   7,  5},	/* 0F8 */
	{   3,  2},	/* 0F9 */
	{   1,  3},	/* 0FA */
	{   2,  2},	/* 0FB */
	{   5,  4},	/* 0FC */
	{   3,  2},	/* 0FD */
	{   4,  3},	/* 0FE */
	{   2,  2},	/* 0FF */
	{  20,  3},	/* 100 */
	{  21,  3},	/* 101 */
	{  36,  4},	/* 102 */
	{   0,  2},	/* 103 */
	{  34,  4},	/* 104 */
	{  42,  4},	/* 105 */
	{  38,  4},	/* 106 */
	{   0,  2},	/* 107 */
	{  20,  3},	/* 108 */
	{  21,  3},	/* 109 */
	{  37,  4},	/* 10A */
	{   0,  2},	/* 10B */
	{  35,  4},	/* 10C */
	{  43,  4},	/* 10D */
	{  39,  4},	/* 10E */
	{   0,  2},	/* 10F */
	{  15,  1},	/* 110 */
	{ 128,  4},	/* 111 */
	{  15,  1},	/* 112 */
	{  28,  4},	/* 113 */
	{  15,  1},	/* 114 */
	{  26,  4},	/* 115 */
	{  15,  1},	/* 116 */
	{  19,  3},	/* 117 */
	{  15,  1},	/* 118 */
	{ 192,  4},	/* 119 */
	{  15,  1},	/* 11A */
	{  29,  4},	/* 11B */
	{  15,  1},	/* 11C */
	{  27,  4},	/* 11D */
	{  15,  1},	/* 11E */
	{  19,  3},	/* 11F */
	{  23,  3},	/* 120 */
	{  57,  4},	/* 121 */
	{  44,  4},	/* 122 */
	{  16,  2},	/* 123 */
	{  50,  4},	/* 124 */
	{  61,  4},	/* 125 */
	{  46,  4},	/* 126 */
	{  16,  2},	/* 127 */
	{  23,  3},	/* 128 */
	{  58,  4},	/* 129 */
	{  45,  4},	/* 12A */
	{  16,  2},	/* 12B */
	{  51,  4},	/* 12C */
	{ 256,  4},	/* 12D */
	{  47,  4},	/* 12E */
	{  16,  2},	/* 12F */
	{  17,  2},	/* 130 */
	{  30,  4},	/* 131 */
	{  48,  4},	/* 132 */
	{  40,  4},	/* 133 */
	{  17,  2},	/* 134 */
	{  32,  4},	/* 135 */
	{  62,  4},	/* 136 */
	{  22,  3},	/* 137 */
	{  17,  2},	/* 138 */
	{  31,  4},	/* 139 */
	{  49,  4},	/* 13A */
	{  41,  4},	/* 13B */
	{  17,  2},	/* 13C */
	{  33,  4},	/* 13D */
	{  63,  4},	/* 13E */
	{  22,  3},	/* 13F */
	{  18,  2},	/* 140 */
	{  56,  4},	/* 141 */
	{  52,  4},	/* 142 */
	{  60,  4},	/* 143 */
	{  18,  2},	/* 144 */
	{1408,  5},	/* 145 */
	{ 768,  5},	/* 146 */
	{  24,  3},	/* 147 */
	{  18,  2},	/* 148 */
	{1280,  5},	/* 149 */
	{ 640,  5},	/* 14A */
	{1536,  5},	/* 14B */
	{  18,  2},	/* 14C */
	{  59,  4},	/* 14D */
	{  55,  4},	/* 14E */
	{  24,  3},	/* 14F */
	{  18,  2},	/* 150 */
	{  56,  4},	/* 151 */
	{  52,  4},	/* 152 */
	{  60,  4},	/* 153 */
	{  18,  2},	/* 154 */
	{1472,  5},	/* 155 */
	{ 832,  5},	/* 156 */
	{  24,  3},	/* 157 */
	{  18,  2},	/* 158 */
	{1344,  5},	/* 159 */
	{ 704,  5},	/* 15A */
	{1600,  5},	/* 15B */
	{  18,  2},	/* 15C */
	{  59,  4},	/* 15D */
	{  55,  4},	/* 15E */
	{  24,  3},	/* 15F */
	{  25,  3},	/* 160 */
	{  54,  4},	/* 161 */
	{ 384,  4},	/* 162 */
	{  64,  2},	/* 163 */
	{1664,  5},	/* 164 */
	{1024,  5},	/* 165 */
	{ 512,  5},	/* 166 */
	{  64,  2},	/* 167 */
	{  25,  3},	/* 168 */
	{ 896,  5},	/* 169 */
	{ 448,  4},	/* 16A */
	{  64,  2},	/* 16B */
	{ 320,  4},	/* 16C */
	{1152,  5},	/* 16D */
	{  53,  4},	/* 16E */
	{  64,  2},	/* 16F */
	{  25,  3},	/* 170 */
	{  54,  4},	/* 171 */
	{ 384,  4},	/* 172 */
	{  64,  2},	/* 173 */
	{1728,  5},	/* 174 */
	{1088,  5},	/* 175 */
	{ 576,  5},	/* 176 */
	{  64,  2},	/* 177 */
	{  25,  3},	/* 178 */
	{ 960,  5},	/* 179 */
	{ 448,  4},	/* 17A */
	{  64,  2},	/* 17B */
	{ 320,  4},	/* 17C */
	{1216,  5},	/* 17D */
	{  53,  4},	/* 17E */
	{  64,  2},	/* 17F */
	{1792,  3},	/* 180 */
	{1856,  3},	/* 181 */
	{2112,  4},	/* 182 */
	{2368,  4},	/* 183 */
	{1984,  4},	/* 184 */
	{1920,  3},	/* 185 */
	{2240,  4},	/* 186 */
	{2496,  4},	/* 187 */
	{1792,  3},	/* 188 */
	{1856,  3},	/* 189 */
	{2176,  4},	/* 18A */
	{2432,  4},	/* 18B */
	{2048,  4},	/* 18C */
	{1920,  3},	/* 18D */
	{2304,  4},	/* 18E */
	{2560,  4} 	/* 18F */
};

#ifdef INTEL_16
# ifdef	FUNTCION
unsigned char bit_get(int x)
{
	if((bitget_skip += x) >= 8){
		bitget_skip -= 8;
		bitget_buf++;
	}
	return (unsigned char)(*(int*)bitget_buf >> bitget_skip);
}
# else
#define	bit_get(x) (unsigned char)((((bitget_skip+=(x))<8)?*(int*)bitget_buf:(bitget_skip-=8,*(int*)(++bitget_buf)))>>bitget_skip)
# endif

#define	bit_get0()	(unsigned char)(*(int*)bitget_buf>>bitget_skip)
#define	bit_get8()	(unsigned char)(*(int*)(++bitget_buf)>>bitget_skip)

#else
unsigned char bit_get(int x)
{
	if ((bitget_skip += x) >= 8){
		bitget_skip -= 8;
		bitget_buf++;
	}
	return (unsigned char)
		(((int)bitget_buf[1]*256 + bitget_buf[0]) >> bitget_skip);
}
#define	bit_get0()	(unsigned char)bit_get(0)
#define	bit_get8()	(unsigned char)bit_get(8)
#endif


int initialize_decode(FILE *fp)
{
	if (faxbuf == NULL && (faxbuf = marea(BUF_SIZE+4)) == NULL)
		return 1;
	bitget_buf = bitget_buf_read = faxbuf;
	bitget_fp = fp;
	bitget_file_pos = ftell(fp);
	bitget_buf_end = NULL;
	bitget_skip = 0;
	return f_MAKE = f_EOF = 0;
}


void move_bitget_buf(int move)
{
	bitget_skip += move;

	while(bitget_skip >= 8){
		bitget_buf++;
		bitget_skip -= 8;
	}
	while(bitget_skip < 0){
		bitget_buf--;
		bitget_skip += 8;
	}
}

static void bitoutinit0(char *s)
{
	bitout_count = 8;
	bitout_buf = (unsigned char*)s;
	bitout_buf_end = bitout_buf + MAX_X_BYTE;
	memset(s, 0, MAX_X_BYTE);
}


static void read_bitget_buf(void)
{
	int	size, result, top;
	char *d;
	long f_pos;

	if (f_EOF) return;
	top = ((char *)bitget_buf - faxbuf >= BUF_BACK)? BUF_BACK:0;
	d = faxbuf;
	if (bitget_buf_end){
		if( (size = bitget_buf_end -  bitget_buf + top) > 0){
			memcpy(faxbuf, bitget_buf - top, size);
			d += size;
		}
	}
	else
		bitget_buf_end = faxbuf + BUF_SIZE;
	bitget_buf = faxbuf + top;

	result = fread( d, BUF_SIZE - (d - faxbuf), 1, bitget_fp );
	f_pos = ftell(bitget_fp);

	if (result != 1){
		f_EOF = 1;
		bitget_buf_end = d;
 		if (f_pos >= 0)
			bitget_buf_end += (f_pos - bitget_file_pos);
		bitget_buf_read = bitget_buf_end;
	}
	else bitget_buf_read = faxbuf + BUF_READ_SIZE;

	for(size = 0, d = bitget_buf_end; size++ < 2; ){
		*d++ = 0;
		*d++ = 0x80;
	}
	bitget_file_pos  = f_pos;
}


static int is_eol(void)
{
	int result;

	if (bit_get0()){
		move_bitget_buf(4);
		result = 1;
	}
	else
		result = (bit_get(4) == 0x80)?0:2;
	bitget_buf++;
	return result;
}

/*
 *  ݂ FAX ̃f[^̐擪̈ʒu𓾂
 */
void get_file_pos(struct FAX_POS *fpos)
{
	fpos->pos  = bitget_file_pos - (bitget_buf_end - bitget_buf);
	fpos->skip = bitget_skip;
}

/*
 *  擪̘A 000000000001(EOL) XLbv
 *  XLbv EOL ̐Ԃ
 */
int count_eol(void)
{
	int	count = 0;

	while(1){
		if (bit_get0()) break;
		if (bit_get(4) == 0x80){
			bitget_buf++;
			count++;
		}
		else{
			move_bitget_buf(-4);
			break;
		}
	}
	return count;
}

/*
 *   RTC T
 */
int next_rtc(void)
{
	unsigned char *tmp;

	bitget_skip = 0;
	while(1){
		while (*++bitget_buf || *(bitget_buf + 3)) {
			if (bitget_buf >= bitget_buf_read){
				if (f_EOF) return 1;
				read_bitget_buf();
			}
		}
		tmp = bitget_buf;
		bitget_buf -= 2;
		if (next_eol()) return 1;
		if (count_eol() >= 4) break;
		bitget_buf = tmp;
	}
	return 0;
}

/*
 *   EOL T
 */
int next_eol(void)
{
	while(1){
		do{
			if (bit_get0())	while(bit_get(3));		/* search 00000000	*/
			bitget_buf++;
		}while(skip_eol());							/* is it not EOL?	*/

		if (bitget_buf < bitget_buf_end) break;
		if (f_EOF) return 1;
		bitget_buf -= 2;
		read_bitget_buf();
	}
	return 0;
}

/*
 *  擪̘A 0 ̌ 1 ̎܂Ői߂
 *
 *    RETURN 0: 11ȏA 0 ̌ 1 ł(Ȃ킿 EOL)
 *    RETURN 1: 11ȏA 0 ̌ 1 ł͂Ȃ
 */
static int skip_eol(void)
{
	unsigned char c;
	int shift;

	while (!*bitget_buf){								/* skip 0 :FILL */
		if (++bitget_buf >= bitget_buf_read && !f_EOF)
			read_bitget_buf();
	};
												/* get the position of 1 */
	c = *bitget_buf;
	for (bitget_skip = 0, shift = 1; !(c & shift); bitget_skip++, shift *= 2);
	move_bitget_buf(-11);
	return is_eol();
}


static int set_white_run(void)
{
	int	run_length, length, pos;

	if( (run_length = white_decode_list[bitget_bitbuf].run) < 64){
		bitget_bitbuf = bit_get(white_decode_list[bitget_bitbuf].length);
set:
		if ((bitout_count -= run_length) <= 0){
			do{
				bitout_buf++;
				bitout_count += 8;
			}while(bitout_count <= 0);
		}
		return 0;

	}
	length = white_decode_list[bitget_bitbuf].length;
	if (length <= 8){
		bitget_bitbuf = bit_get(length);
	}else{
		bitget_bitbuf = bit_get8();
		pos = run_length + (bitget_bitbuf & MASK[length-8]);
		run_length = white_decode_list[pos].run;
		bitget_bitbuf = bit_get(white_decode_list[pos].length);
	}
	if (run_length == 0x7fff)	return  1;			/* 00000000...		*/
	if (run_length < 64) 		goto set;			/* always false		*/
	if (f_MAKE)					return -1;			/* MAKE UP Codes	*/
	f_MAKE = 1;
	bitout_buf += run_length/8;
	return f_MAKE = set_white_run();
}


static int set_black_run(void)
{
	int	run_length, length, pos;

	if( (run_length = black_decode_list[bitget_bitbuf].run) < 64){
		bitget_bitbuf = bit_get(black_decode_list[bitget_bitbuf].length);
set:
		if (bitout_count > run_length){
			*bitout_buf |= MASK[bitout_count];
			*bitout_buf &= SET[bitout_count -= run_length];
			return 0;
		}else{
			*bitout_buf++ |= MASK[bitout_count];
			run_length -= bitout_count;
			while(run_length >= 8){
				run_length -= 8;
				*bitout_buf++ = 0xff;
			}
			*bitout_buf = SET[bitout_count = 8 - run_length];
			return 0;
		}

	}
	length = black_decode_list[bitget_bitbuf].length;
	if (length <= 8){
		bitget_bitbuf = bit_get(length);
	}else{
		bitget_bitbuf = bit_get8();
		pos = run_length + (bitget_bitbuf & MASK[length-8]);
		run_length = black_decode_list[pos].run;
		bitget_bitbuf = bit_get(black_decode_list[pos].length);
	}
	if (run_length == 0x7fff)	return  1;			/* 00000000...		*/
	if (run_length < 64) 		goto set;
	if (f_MAKE)					return -1;			/* MAKE UP Codes	*/
	f_MAKE = 1;
	if((f_MAKE = set_black_run())== 0) goto set;
	return -1;
}


int fax_decode_line(char *dast)
{
	int result;

	if (bitget_buf >= bitget_buf_read)
		read_bitget_buf();
	bitget_bitbuf = bit_get0();
	bitoutinit0(dast);

	for(;;){
		if( (result = set_white_run()) != 0 ) break;
		if( bitout_buf > bitout_buf_end )
			return TOO_LONG_LINE;
		if( (result = set_black_run()) != 0 ) break;
	}
	if (bitget_buf >= bitget_buf_end)
		return (f_EOF)? END_OF_DATA:OUT_OF_DATA;
	if (result == 1){									/* 00000000... */
		if (!skip_eol())
			return (((char *)bitout_buf - dast)*8 + bitout_count - 8);
		else
			return BAD_DATA;
	}
	f_MAKE = 0;
	return DOUBLE_MAKE;
}
#endif
