
.TH Crudetype 1 "Feb 1989"
.SH NAME
Crudetype \- Lineprinter output from DVI files.
.SH SYNOPSIS
.B crudetype
.RB "[\|" \-b "\|]"
.RB "[\|" \-c
.IR countpages "\|]"
.RB "[\|" \-d
.IR font-directory "\|]"
.RB "[\|" \-f
.IR firstpage "\|]"
.RI "[\|" \-i "[\|" page-height "\|]\|]"
.RB "[\|" \-m
.IR magnify "\|]"
.RB "[\|" \-p
.IR printfile "\|]"
.RB "[\|" \-q "\|]"
.RB "[\|" \-r "\|]"
.RB "[\|" \-s "\|]"
.RB "[\|" \-x
.IR X-mag "\|]"
.RB "[\|" \-y
.IR Y-mag "\|]"
.RI "[\|" dvifile "[\|" .dvi "\|]\|]"
.SH DESCRIPTION
.IX crudetype"" "\fLcrudetype\fR \(em Lineprinter output from DVI files.''
.I Crudetype
takes a standard TeX DVI file and generates output
suitable for printing on a lineprinter. Of course no lineprinter can possibly
do justice to the power of TeX, but it does give a fairly good idea of what
your output would look like on a respectable printer.Thus
.I Crudetype
is very useful in the early stages of debugging TeX input, because you
do not need any special equipment to run it and lineprinter output is
less expensive than laserprinter output. The output file can also be
inspected with editors or passed directly to your VDU but for this you
need a 132-column-wide terminal. Also because VDUs cannot show
overstruck characters, these appear in incorrect positions.


.SH OPTIONS
.PP
.TP
.BI \-b
(Batch-view) Produces a file more suitable for viewing through an 
editor. The main change is that overstruck characters are omitted.
.TP
.BI \-c " number"
Stop after this many pages. Normally 
.I Crudetype
will print all pages.
.TP
.BI \-d " font-directory"
Look for font files here instead of the standard TEXFONTS environment
variable. Note the punctuation is peculiar, e.g. '-d/strange/place/.tfm' 
.TP
.BI \-f " number"
Start printing at the first page whose 
.I count0
parameter is greater than or equal to the specified number.
.TP
.BI \-i " number"
(Inspect) Produce immediate output on the terminal. The number N is 
optional. If it is specified, Crudetype pauses after every N lines. 
If it is missing, the default is 20. N=0 specifies no pausing. 
.TP
.BI \-m " number"
Magnify by (number)/100. Some magnification is needed because
most TeX characters are narrower than lineprinter characters. I
do not know any plausible algorithm for adjusting the magnification
according to the fonts being used. The least bad alternative seemed to
be to allow the user to specify a magnification; the default is
adjusted so some files look reasonable on a lineprinter. Now replaced by
.BI \-x 
and 
.BI \-y
(see below); retained only for compatibility.
.TP
.BI \-p " printfile"
Send output to the named file instead of the default. The  
default output file name is:
(current default directory)(DVI file name)(.lpr)
.TP
.B \-q
(quiet) Suppress information messages.
.TP
.B \-r
(run on) Suppress form feeds; instead 
.I Crudetype
prints a string 
like  ----- PAGE n ----- .
.TP
.B \-s
(squash) Suppress blank lines in the printed output. Normally, 
output is double-spaced to allow space for super- and subscripts.
.TP
.BI \-x " number"
.TP
.BI \-y " number"
Specify separate horizontal and vertical magnifications. As with 
-m, the number is regarded as a percentage. If -m is also specified,
both magnifications take effect.

.SH AUTHOR
.PP
Program: R.M.Damerell, Maths Dept., RHBNC., Egham,
Surrey, U.K. Unix changefile: P.King, Heriot-Watt University,
Edinburgh, U.K. Bug reports to RMD please, E-mail address 
DAMERELL  at  UK.AC.NSFNET-RELAY.
.TP
Program is copyright,
supplied free, AS IS with no guarantee of performance or support.

