#include "linelist.h"
#include "ansifont.h"
#include <algorithm>

using namespace std;

deque<char *>::iterator NULL_ITERATOR;

/*! this will never be called since the width is determined after the CTextImage holding this
	is instantiated */
CLineList::CLineList() :
	m_maxLines(0xFFFFFFFF)		
{

	/*! \todo should not have a default setting of an 80 width, should just have every loaders make a call
		to init */
	init(160);
}


CLineList::~CLineList() {

	for(deque<char *>::iterator i=m_list.begin(); i!=m_list.end(); i++)
		delete [] (*i);

	m_list.clear();
}

void CLineList::reset() {
	m_current = NULL_ITERATOR;
	m_xsaved  = 0;
	m_ysaved  = 0;
}

void CLineList::init(int w) {

	//Needed for refreshes like for avi saving
	this->~CLineList();
	m_width   = w;
	reset();
}


char *CLineList::forwardCat() {

	m_current = (m_current==NULL_ITERATOR)?m_list.begin():m_current+1;
	
	if (m_current==m_list.end()) {
		
		char *line = new char[m_width];
		initLine(line);
		m_list.push_back(line);		
		if (m_list.size()>m_maxLines)
			m_list.pop_front();

		bottom();
	} 

	return *m_current;
}


char *CLineList::backwardCat() {

	m_current = (m_current==NULL_ITERATOR)?m_list.begin() : 
				(m_current==m_list.begin())?NULL_ITERATOR: m_current-1;

	if (m_current==NULL_ITERATOR) {

		char *line = new char[m_width];
		initLine(line);
		m_list.insert(m_list.begin(), line);
		if (m_list.size()>m_maxLines)
			m_list.pop_back();

		top();
	} 
	return *m_current;

}


void CLineList::initLine(char *line) {
	
	for (int i=0; i<m_width; i+=2) {
		line[i]   = ' ';
		line[i+1] = BIN_WHITE;
	}	
}

char *CLineList::getContents() {
	return *m_current;
}

void CLineList::savePosition(int x) {
	m_xsaved = x;
	m_ysaved = getY();
}

int CLineList::loadSavedPosition() {
/*! \note may be off by one here */
	m_current = m_list.begin()+m_ysaved;	
	return m_xsaved;
}

void CLineList::rewind() {
	m_current = NULL_ITERATOR;
}

int CLineList::getHeight() {
	return m_list.size();
}

int CLineList::getWidth() {
	return m_width;
}

/*! \todo recode */
int CLineList::getY() {

	int y=0;	
	for (deque<char *>::iterator i=m_list.begin(); i!=m_list.end(); i++, y++) {
		if (*i==*m_current) 
			return y;
	}
	return -1;
}

char *CLineList::bottom() {
	m_current = m_list.end();
	if (m_current!=m_list.begin())
		m_current--;
	else
		m_current = NULL_ITERATOR;
	return *m_current;
}

char *CLineList::top() {
	m_current = m_list.begin();	
	return *m_current;
}

char *CLineList::forward() {

	if (m_current==NULL_ITERATOR) {
		m_current = m_list.begin();
	} else if ((m_current+1)!=m_list.end()) {
		m_current++;
	}
	return *m_current;
}

char *CLineList::backward() {
	m_current = m_current==m_list.begin()?m_current:m_current-1;
	return *m_current;
}