#include "textrenderer.h"
#include "AcidImage.h"
#include "ImageContext.h"
#include "TextData.h"

#include "mmintrin.h"
#include <deque>

using namespace std;


CTextRenderer::CTextRenderer() :
	m_lineBufferSize(0,0),
	m_lineBufferUI(0),
	m_lineBufferBI(0),
	m_lastTopLine(-1),
	m_lastBottomLine(-1),
	m_lastRightCol(-1),
	m_lastLeftCol(-1)
{

}


CTextRenderer::~CTextRenderer() {

	if (m_lineBufferUI) {
		delete [] m_lineBufferUI;
	}
	
	if (m_lineBufferBI) {
		delete [] m_lineBufferBI;
	}
}


int CTextRenderer::getWidth(CImageContext *context, CImageData *imageData) {

	CTextData *data = (CTextData *)imageData;
	//return ((data->m_list->getWidth()/2)*context->m_font->m_charWidth)/(1<<context->m_resolution);

	int w = context->m_font->m_charWidth;
	w += context->m_9thPixel?1:0;
	return ((data->m_list->getWidth()/2)*w)/(1<<context->m_resolution);
}


int CTextRenderer::getHeight(CImageContext *context, CImageData *imageData) {

	CTextData *data = (CTextData *)imageData;
	int h = context->m_recordMovie ? 25 : data->m_list->getHeight();
	//int h = context->m_recordMovie ? 26 : data->m_list->getHeight();
	return (h*context->m_font->m_charHeight)/(1<<context->m_resolution);
}


/*! Set the image to the parameter and rescale the backbuffers if necessary 
	\todo this could be made more robust to handle different contexts better
*/
void CTextRenderer::setImage(CImageContext *context, CImageData *data) {

	m_lastTopLine	 = -1;
	m_lastBottomLine = -1;
	m_lastRightCol	 = -1;
	m_lastLeftCol	 = -1;

	CTextData *textData = (CTextData *)data;
	CAnsiFont *font		= (textData->m_userFont)?textData->m_userFont:context->m_font;
	int height			= __max(16, font->m_charHeight);
	//int width			= (textData->m_list->getWidth()/2)*font->m_charWidth;	
	int width			= (textData->m_list->getWidth()/2)*(font->m_charWidth+1);	

	if (width>m_lineBufferSize.cx || height>m_lineBufferSize.cy) {

		m_lineBufferSize.cx = __max(width, m_lineBufferSize.cx);
		m_lineBufferSize.cy = __max(height, m_lineBufferSize.cy);

		if (m_lineBufferUI) {
			delete [] m_lineBufferUI;
		}
		//8 is the pixels width of the chars and 4 is the number of bytes per pixels
		m_lineBufferUI = new unsigned int[m_lineBufferSize.cx*m_lineBufferSize.cy];

		if (!m_lineBufferBI) {
			m_lineBufferBI = new BITMAPINFO;
			m_lineBufferBI->bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
			m_lineBufferBI->bmiHeader.biPlanes			= 1;
			m_lineBufferBI->bmiHeader.biBitCount		= 32;
			m_lineBufferBI->bmiHeader.biCompression		= BI_RGB;
			m_lineBufferBI->bmiHeader.biSizeImage		= 0;
			m_lineBufferBI->bmiHeader.biXPelsPerMeter	= 1;
			m_lineBufferBI->bmiHeader.biXPelsPerMeter	= 1;
			m_lineBufferBI->bmiHeader.biClrUsed			= 0;
			m_lineBufferBI->bmiHeader.biClrImportant	= 0;			
		}

		m_lineBufferBI->bmiHeader.biWidth	= m_lineBufferSize.cx;
		m_lineBufferBI->bmiHeader.biHeight	= m_lineBufferSize.cy;
	}
}


int CTextRenderer::invalidateRect(CImageContext *context, CImageData *data, CRect rc, int &xoffs, int &yoffs) {
	

	CTextData	*textData  = (CTextData *)data;
	CAnsiFont *font		 = (textData->m_userFont)?textData->m_userFont:context->m_font;
	ANSIPalette *palette = (textData->m_userPalette)?textData->m_userPalette:context->m_palette;

	int numBits		= context->m_pDC->GetDeviceCaps(BITSPIXEL);
	int scale		= 1<<context->m_resolution;
	//int scaledWidth = font->m_charWidth/scale;
	int scaledWidth = (font->m_charWidth+(context->m_9thPixel?1:0))/scale;
	int scaledHeight= font->m_charHeight/scale;

	int topLine		= (int)(rc.top/scaledHeight);
	int bottomLine	= (int)((rc.bottom)/scaledHeight)+1;
	topLine			= (topLine<0)?0:topLine;
	bottomLine		= (bottomLine>textData->m_list->getHeight())?textData->m_list->getHeight():bottomLine;

	int leftCol		= (int)(rc.left/scaledWidth);
	int rightCol	= (int)(rc.right/scaledWidth)+1;
	leftCol			= (leftCol<0)?0:leftCol;
	rightCol		= (rightCol>(textData->m_list->getWidth()/2))?(textData->m_list->getWidth()/2):rightCol;

	xoffs = rc.left - leftCol*scaledWidth;
	yoffs = rc.top  - topLine*scaledHeight;

 
	//If the thread is active, then there is an ansimation and render that instead
	/*! \todo get rid of this, cview should call the correct function.. or maybe cacidimage should do that */
	if (!textData->getThreadDone()) {
		return invalidateRectAnimation(context, data, rc, xoffs, yoffs);
	}

	if (textData->hasCommands()) {
		AnsiCommandData a;
		while(textData->getNextCommand(a)!=-1) {
			textData->executeCommand(&a);
		}
	}

	int h = 0;
	char bgAndAmt	 =	(context->m_iceColors | textData->m_iceColors) ? 0xF : 
						context->isAscii() ? 0 : 0x7;

	m_lineBufferBI->bmiHeader.biHeight = scaledHeight;
	m_lineBufferBI->bmiHeader.biWidth  = scaledWidth*(rightCol-leftCol);
	for(deque<char *>::iterator i=(textData->m_list->m_list.begin()+topLine); i!=(textData->m_list->m_list.begin()+bottomLine); i++, h+=scaledHeight) {
		
		if (context->m_9thPixel) {
			renderChars9(context, 
				font, 
				palette, 
				bgAndAmt, 
				*i, 
				leftCol*2, 
				rightCol*2, 
				m_lineBufferUI);		
		} else {
			renderChars(context, 
				font, 
				palette, 
				bgAndAmt, 
				*i, 
				leftCol*2, 
				rightCol*2, 
				m_lineBufferUI);		
		}

		SetDIBitsToDevice(	context->m_pDC->GetSafeHdc(), 
							0, h, (rightCol-leftCol)*scaledWidth, scaledHeight,
							0, 0, 0, scaledHeight, m_lineBufferUI, m_lineBufferBI, DIB_RGB_COLORS);
	}

	return 0;
}


int CTextRenderer::invalidateRectAnimation(CImageContext *context, CImageData *data, CRect rc, int &xoffs, int &yoffs) {

	CTextData *textData = (CTextData *)data;

	CAnsiFont *font		 = (textData->m_userFont)?textData->m_userFont:context->m_font;
	ANSIPalette *palette = (textData->m_userPalette)?textData->m_userPalette:context->m_palette;
	bool iceColors		 = context->m_iceColors | textData->m_iceColors;
	int numBits		= context->m_pDC->GetDeviceCaps(BITSPIXEL);
	int scale		= 1<<context->m_resolution;
	int scaledWidth = font->m_charWidth/scale;
	int scaledHeight= font->m_charHeight/scale;

	char bgAndAmt	 = (context->m_iceColors | textData->m_iceColors) ? 0xF : (context->isAscii()) ? 0 : 0x7;

	AnsiCommandData a;
	m_lineBufferBI->bmiHeader.biHeight = scaledHeight;
	m_lineBufferBI->bmiHeader.biWidth  = scaledWidth;
	while(textData->getNextCommand(a)!=-1) {

		int x = textData->m_x;
		int y = textData->m_list->getY();
		char *current = textData->m_list->getContents();
		deque<char *>::iterator lastLine=textData->m_list->m_list.end()-1;
		textData->executeCommand(&a);

		
		if (a.command==ANSI_CLEAR_SCREEN) {
			//context->m_pDC->PatBlt(0, 0, scaledWidth*80, scaledHeight*26, BLACKNESS);	

			//see CTextData::clearScreen
			switch(a.argbuf[0]) {
				//1 	Erase from start of the screen to the active position, inclusive
			case '1':
					context->m_pDC->PatBlt(0, 0, scaledWidth*80, scaledHeight*(y+1), BLACKNESS);	
					break;
				//2 	Erase all of the display -- all lines are erased, changed to single-width, and the cursor does not move.
				case '2':
					context->m_pDC->PatBlt(0, 0, scaledWidth*80, scaledHeight*26, BLACKNESS);	
					break;
				//0 	Erase from the active position to the end of the screen, inclusive (default)
				case '0':
				default:
					context->m_pDC->PatBlt(0, scaledHeight*y, scaledWidth*80, scaledHeight*(26-y), BLACKNESS);	
					break;
			}
		} else if (a.command==ANSI_CLEAR_LINE) {
			//context->m_pDC->PatBlt(0, y*scaledHeight, scaledWidth*80, scaledHeight, BLACKNESS);				

			// see CTextData::clearLine()
			switch(a.argbuf[0]) {
				//1 			Erase from the start of the screen to the active position, inclusive
				case '1':
					context->m_pDC->PatBlt(0, y*scaledHeight, scaledWidth*(x+1), scaledHeight, BLACKNESS);				
					break;
				//2 			Erase all of the line, inclusive 
				case '2':
					context->m_pDC->PatBlt(0, y*scaledHeight, scaledWidth*80, scaledHeight, BLACKNESS);				
					break;
				//0 			Erase from the active position to the end of the line, inclusive (default)
				case '0':
				default:
					context->m_pDC->PatBlt(x*scaledWidth, y*scaledHeight, scaledWidth*(80-x), scaledHeight, BLACKNESS);				
					break;
			}
		} else if (a.command==ANSI_STORE) {
			
			char ch[] = {current[x*2], current[x*2+1]};
			renderChars(context, 
						font, 
						palette, 
						bgAndAmt, 
						ch, 
						0, 
						2, 
						m_lineBufferUI);				
//			::SetDIBits(context->m_pDC->GetSafeHdc(), *m_charBufferB, 0, m_charBufferSize.cy, m_charBufferUI, m_charBufferBI, DIB_RGB_COLORS);
			deque<char *>::iterator newLastLine=textData->m_list->m_list.end()-1;
			if (newLastLine!=lastLine) {
				context->m_pDC->ScrollDC(0, -scaledHeight, &rc, &rc, NULL, NULL);
				//context->m_pDC->PatBlt(0, 25*scaledHeight, scaledWidth*80, scaledHeight, BLACKNESS);		
			}

			//context->m_pDC->BitBlt(x*scaledWidth, y*scaledHeight, scaledWidth, scaledHeight, &chardc, 0, 0, SRCCOPY);			
			SetDIBitsToDevice(	context->m_pDC->GetSafeHdc(), 
						x*scaledWidth, y*scaledHeight, scaledWidth, scaledHeight,
						0, 0, 0, scaledHeight, m_lineBufferUI, m_lineBufferBI, DIB_RGB_COLORS);

		} 
	}

	return 0;
}

/*! \todo blink@ */
void CTextRenderer::renderChars(CImageContext *context, 
									   CAnsiFont *font, 
									   ANSIPalette *palette, 
									   char bgAndAmt, 
									   const char *chars,
									   int start,
									   int end, 
									   unsigned int *dest) {		

	int scale        = context->m_resolution;
	int scaledWidth  = font->m_charWidth/(1<<scale);
	int scaledHeight = font->m_charHeight/(1<<scale);
	int fs			 = scaledWidth*scaledHeight;
	unsigned int *fsrc = font->m_chars[scale];

	//for hidden messages
	int bgAnd2		 = (bgAndAmt)?0xFFFFFF:0;

/*
	for (int i=0; i<font->m_charHeight/(1<<scale); i++) {

		unsigned int *dest2 = dest + (font->m_charHeight-1-i)*lineWidth;
		__m64 zero = _mm_setzero_si64();
		//For each char
		for (int j=start; j<end; j+=2) {
		
			unsigned char ch	= chars[j];
			unsigned char att	= chars[j+1];
			unsigned char fgCol = att&0xF;
			unsigned char bgCol = (att>>4)&bgAndAmt;

			COLORREF fg = palette->cols[fgCol];
			COLORREF bg = palette->cols[bgCol];

			__m64 fg64 = _mm_cvtsi32_si64(fg);
			__m64 bg64 = _mm_cvtsi32_si64(bg);

			fg64 = _mm_unpacklo_pi8(fg64, zero);
			bg64 = _mm_unpacklo_pi8(bg64, zero);

			unsigned char *font_bitmap = font->getCharPointer(ch, i, scale);
			for (int mask,k=0; k<scaledWidth; k++) {

				mask			= (unsigned char)*font_bitmap++;
				mask			= mask|(mask<<8)|(mask<<16);
				__m64 mask64	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(mask), zero);
				__m64 mask64i	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(~mask), zero);

				__m64 a			= _mm_mullo_pi16(fg64, mask64);
				__m64 b			= _mm_mullo_pi16(bg64, mask64i);
				a				= _mm_adds_pu16(a, b);
				a				= _mm_srl_pi16(a, _mm_cvtsi32_si64(8));
				a				= _mm_packs_pu16(a, zero);

				*dest2++		= _mm_cvtsi64_si32(a);
			}
		}
	}
*/

	//unsigned int  *dstart = dest + (bitmapHeight-1)*bitmapWidth;
	int bitmapWidth = (end/2-start/2)*scaledWidth;
	unsigned int  *dstart = dest + (scaledHeight-1)*bitmapWidth;
	__m64 zero = _mm_setzero_si64();

	for (int j=start; j<end; j+=2, dstart+=scaledWidth) {

		unsigned int *font_bitmap = fsrc + (int)(unsigned char)(chars[j])*fs;		

		unsigned char att	= chars[j+1];
		__m64 fg64  = _mm_unpacklo_pi8( _mm_cvtsi32_si64( palette->cols[ att&0xF           ] ), zero);
		__m64 bg64  = _mm_unpacklo_pi8( _mm_cvtsi32_si64( palette->cols[ (att>>4)&bgAndAmt ] & bgAnd2 ), zero);
		
		unsigned int *dest2 = dstart;
		for (int i=0; i<scaledHeight; i++) {		
			
			for (int k=0; k<scaledWidth; k++) {

				__m64 mask64	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(*font_bitmap),  zero);
				__m64 mask64i	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(~*font_bitmap), zero);

				__m64 a			= _mm_mullo_pi16(fg64, mask64);
				__m64 b			= _mm_mullo_pi16(bg64, mask64i);
				a				= _mm_adds_pu16(a,     b);
				a				= _mm_srl_pi16(a,      _mm_cvtsi32_si64(8));
				a				= _mm_packs_pu16(a,    zero);

				*dest2++		= _mm_cvtsi64_si32(a);
				font_bitmap++;
			}	
			
			dest2 -= (bitmapWidth + scaledWidth);			
		}
	}

	_mm_empty();
}

void CTextRenderer::renderChars9(CImageContext *context, 
									   CAnsiFont *font, 
									   ANSIPalette *palette, 
									   char bgAndAmt, 
									   const char *chars,
									   int start,
									   int end, 
									   unsigned int *dest) {		

	int scale        = context->m_resolution;
	
	int scaledWidth  = (font->m_charWidth+1)/(1<<scale);
	int scaledWidth8 = (font->m_charWidth)/(1<<scale);

	int scaledHeight = font->m_charHeight/(1<<scale);
	int fs			 = scaledWidth8*scaledHeight;
	unsigned int *fsrc = font->m_chars[scale];

	//for hidden messages
	int bgAnd2		 = (bgAndAmt)?0xFFFFFF:0;

	int bitmapWidth = (end/2-start/2)*scaledWidth;
	unsigned int  *dstart = dest + (scaledHeight-1)*bitmapWidth;
	__m64 zero = _mm_setzero_si64();



	for (int j=start; j<end; j+=2, dstart+=scaledWidth) {

		unsigned int *font_bitmap = fsrc + (int)(unsigned char)(chars[j])*fs;		

		unsigned char ch    = (unsigned char)chars[j];
		unsigned char att	= chars[j+1];
		
		unsigned int fg32   = palette->cols[ att&0xF];
		unsigned int bg32	= palette->cols[ (att>>4)&bgAndAmt ] & bgAnd2;

		__m64 fg64  = _mm_unpacklo_pi8( _mm_cvtsi32_si64( fg32 ), zero);
		__m64 bg64  = _mm_unpacklo_pi8( _mm_cvtsi32_si64( bg32 ), zero);
		
		unsigned int *dest2 = dstart;
		for (int i=0; i<scaledHeight; i++) {		
			
			for (int k=0; k<scaledWidth; k++) {

				unsigned int lastcol;
				if (k<scaledWidth8) {
					__m64 mask64	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(*font_bitmap),  zero);
					__m64 mask64i	= _mm_unpacklo_pi8(_mm_cvtsi32_si64(~*font_bitmap), zero);

					__m64 a			= _mm_mullo_pi16(fg64, mask64);
					__m64 b			= _mm_mullo_pi16(bg64, mask64i);
					a				= _mm_adds_pu16(a,     b);
					a				= _mm_srl_pi16(a,      _mm_cvtsi32_si64(8));
					a				= _mm_packs_pu16(a,    zero);

					lastcol			= _mm_cvtsi64_si32(a);
					*dest2++		= lastcol;
					font_bitmap++;
				} else {			
					if (ch>=192 && ch<=223)
						*dest2++		= lastcol;
					else
						*dest2++		= bg32;
				}
			}	
			
			dest2 -= (bitmapWidth + scaledWidth);			
		}
	}

	_mm_empty();
}
