#include "TextLoader.h"

CTextLoader::CTextLoader(CImageRenderer *renderer) :
	CImageLoader(renderer) 
{


}


CTextLoader::~CTextLoader() {

}


void CTextLoader::startLoad(CImageContext *context, CImageData *data) {

	m_renderer->setImage(context, data);
}

CImageData *CTextLoader::loadFile(const char *filename) {

	CTextData *textData = new CTextData();
	textData->copyFilename(filename);
	textData->loadFileAsBinary(filename);
	if (textData->m_sauce)
		textData->m_fileLength -= 128;

	loadFileFromDataImp(textData->m_fileData, textData->m_fileLength, textData);
	return textData;
}


CImageData *CTextLoader::loadFileFromData(const char *data, const int length) {

	CTextData *textData		= new CTextData();
	textData->m_animateable = false;
	textData->m_sauce		= getSauceFromData(data, length);
	if (textData->m_sauce)
		textData->m_fileLength -= 128;
	loadFileFromDataImp(data, length, textData);
	return textData;
}
