#pragma once


#include "BinaryData.h"
#include "ImageContext.h"
#include "StdAfx.h"
#include <deque>
#include <vector>


enum RipCommand {

	RIP_GET_IMAGE,
	RIP_PUT_IMAGE,
	RIP_TEXT,
	RIP_TEXT_XY,
	RIP_FONT_STYLE,
	RIP_COLOR,
	RIP_PIXEL,
	RIP_LINE,
	RIP_RECTANGLE,
	RIP_ONE_PALETTE,
	RIP_SET_PALETTE,
	RIP_WRITE_MODE,
	RIP_MOVE,
	RIP_BAR,
	RIP_CIRCLE,
	RIP_OVAL_PIE_SLICE,
	RIP_OVAL,
	RIP_FILLED_OVAL,
	RIP_POLYGON,
	RIP_FILL_POLYGON,
	RIP_POLYLINE,
	RIP_FILL,
	RIP_LINE_STYLE,
	RIP_FILL_STYLE,
	RIP_BEZIER,
	RIP_ARC,
	RIP_OVAL_ARC,
	RIP_PIE_SLICE,
	RIP_FILL_PATTERN,
	RIP_END,

	RIP_NONE
};


class CRipCommandData {
	

public:
	RipCommand			m_command;
	CString				m_text;
	std::vector<int>	m_data;


	CRipCommandData() { }

	~CRipCommandData() {
		m_data.clear();
	}

	void addInt(int i) {
		m_data.push_back(i);
	}

	CRipCommandData& operator=(CRipCommandData &cmd) {

		m_command = cmd.m_command;
		m_text    = cmd.m_text;
		m_data.clear();
		for(std::vector<int>::iterator i=cmd.m_data.begin(); i!=cmd.m_data.end(); i++) {
			int k = *i;
			m_data.push_back(k);
		}
		return *this;
	}
};


enum RipWriteMode {
	Normal=0,
	Xor=1
};

struct RipLine {
	int pattern, userPattern, thickness;
};

struct RipFont {
	int font, direction, size, res;
};

struct RipPattern {
	int pattern, color;
	int userColor;
	char userPattern[8];
};


class CRipData : public CBinaryData {

private:

	std::deque<CRipCommandData>	m_buffer;
	//Helper Functions
	unsigned int	getCol(int);	

	//Command Implementations
	void	ripGetImage(CRipCommandData *);		
	void	ripPutImage(CRipCommandData *);		
	void	ripText(CRipCommandData *);			
	void	ripTextXY(CRipCommandData *);		
	void	ripFontStyle(CRipCommandData *);		
	void	ripColor(CRipCommandData *);			
	void	ripPixel(CRipCommandData *);			
	void	ripLine(CRipCommandData *);			
	void	ripRectangle(CRipCommandData *);		
	void	ripOnePalette(CRipCommandData *);	
	void	ripSetPalette(CRipCommandData *);	
	void	ripWriteMode(CRipCommandData *);		
	void	ripMove(CRipCommandData *);			
	void	ripBar(CRipCommandData *);			
	void	ripCircle(CRipCommandData *);		
	void	ripOvalPieSlice(CRipCommandData *);	
	void	ripOval(CRipCommandData *);			
	void	ripFilledOval(CRipCommandData *);	
	void	ripPolygon(CRipCommandData *);		
	void	ripFillPolygon(CRipCommandData *);	
	void	ripPolyline(CRipCommandData *);		
	void	ripFill(CRipCommandData *);			
	void	ripLineStyle(CRipCommandData *);		
	void	ripFillStyle(CRipCommandData *);		
	void	ripBezier(CRipCommandData *);		
	void	ripArc(CRipCommandData *);			
	void	ripOvalArc(CRipCommandData *);		
	void	ripPieSlice(CRipCommandData *);		
	void	ripFillPattern(CRipCommandData *);	

public:
	
	int				m_curX, m_curY;
	int				m_drawCol;
	int				m_pal[16];
	RipWriteMode	m_writeMode;

	CDC				*m_pDC, *m_ownDC;
	CPen			*m_pen;
	CBrush			*m_brush;	
	CBitmap			*m_fillBitmap;

	CDC				*m_pClipboardDC;
	CBitmap			*m_clipboardBitmap;
	int				m_clipboardWidth, m_clipboardHeight;
	int				m_savedDC;

	RipLine			m_line;
	RipFont			m_font;
	RipPattern		m_fill;


	CRipData();
	~CRipData();

	void	setPen(int pattern=-1, int userPattern=-1);
	void	setBrush();
	void	loadStandardPalette();
	void	init(CImageContext *);

	void	addCommand(CRipCommandData *);
	int		getNextCommand(CRipCommandData &);
	void	executeCommand(CRipCommandData *);
	bool	hasCommands();
};

