// Preferences.cpp : implementation file
//

#include "stdafx.h"
#include "acidview.h"
#include "Preferences.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPreferences dialog


CPreferences::CPreferences(CWnd* pParent /*=NULL*/)
	: CDialog(CPreferences::IDD, pParent),
	m_bStartSlideShow(false)
{
	//{{AFX_DATA_INIT(CPreferences)
	m_bCycle = FALSE;
	m_bRandom = FALSE;
	m_delay = _T("");
	m_directory = _T("");
	m_textFile = _T("");
	m_location = -1;
	m_bStartFullscreen = FALSE;
	m_fullscreen = -1;
	//}}AFX_DATA_INIT
}


void CPreferences::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPreferences)
	DDX_Check(pDX, IDC_CHECK_CYCLE, m_bCycle);
	DDX_Check(pDX, IDC_CHECK_RANDOM, m_bRandom);
	DDX_Text(pDX, IDC_EDIT_DELAY, m_delay);
	DDX_Text(pDX, IDC_EDIT_DIRECTORY, m_directory);
	DDX_Text(pDX, IDC_EDIT_TEXT_FILE, m_textFile);
	DDX_Radio(pDX, IDC_RADIO_TEXT_FILE, m_location);
	DDX_Check(pDX, IDC_CHECK_START_FULLSCREEN, m_bStartFullscreen);
	DDX_Radio(pDX, IDC_RADIO_640X400, m_fullscreen);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPreferences, CDialog)
	//{{AFX_MSG_MAP(CPreferences)
	ON_BN_CLICKED(IDC_BUTTON_TEXT_FILE, OnButtonTextFile)
	ON_BN_CLICKED(IDC_BUTTON_DIRECTORY, OnButtonDirectory)
	ON_BN_CLICKED(IDC_BUTTON_START_SLIDESHOW, OnButtonStartSlideshow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPreferences message handlers

void CPreferences::OnButtonTextFile() {

	CFileDialog dlg(TRUE, 
					"*.txt", 
					m_textFile, 
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
					"Text Files (*.txt)|*.txt|All Files (*.*)|*.*||");
	if (dlg.DoModal()==IDOK) {
		m_textFile = dlg.GetPathName();
		UpdateData(FALSE);
	}		
}


void CPreferences::OnButtonDirectory() {

	CFileDialog dlg(TRUE, 
					"*.rar; *.zip", 
					NULL, 
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
					"Compressed Files (*.rar; *.zip)|*.rar; *.zip|All Files (*.*)|*.*||");
	if (dlg.DoModal()==IDOK) {
		m_directory = dlg.GetPathName();
		UpdateData(FALSE);
	}				
}

BOOL CPreferences::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_bCycle			= m_slideShow.bCycle;
//	m_bCompressedFiles	= m_slideShow.bCompressedFiles;
	m_bRandom			= m_slideShow.bRandom;
//	m_bSubdirectories	= m_slideShow.bSubdirectories;
	m_bStartFullscreen  = m_slideShow.bStartFullscreen;
	m_directory			= m_slideShow.directory;
	m_textFile			= m_slideShow.textFile;
	m_delay.Format("%d", m_slideShow.delay);
	if (m_slideShow.bUseTextFile) {
		m_location = 0;
	} else {
		m_location = 1;
	}

	UpdateData(FALSE);

	return TRUE;  
}

void CPreferences::OnOK() 
{

	UpdateData(TRUE);

	m_slideShow.bCycle				= !!m_bCycle;
//	m_slideShow.bCompressedFiles	= m_bCompressedFiles;
	m_slideShow.bRandom				= !!m_bRandom;
//	m_slideShow.bSubdirectories		= m_bSubdirectories;
	m_slideShow.bStartFullscreen	= !!m_bStartFullscreen;
	m_slideShow.bUseTextFile		= (m_location==0);
	m_slideShow.delay				= atoi(m_delay);
	m_slideShow.directory			= m_directory;
	m_slideShow.textFile			= m_textFile;
	CDialog::OnOK();
}

void CPreferences::OnButtonStartSlideshow() 
{
	m_bStartSlideShow = true;
	OnOK();
}
