#include "PngLoader.h"
#include <png.h>


#define ERROR 0


CPngLoader::CPngLoader(CImageRenderer *renderer) :
	CBinaryLoader(renderer)
{
	
}

CPngLoader::~CPngLoader() {
	
}

/*! \todo fix, there is a sig, just an ugly one */
bool CPngLoader::isFileType(const char *signature, const char *filename) {

	return !png_sig_cmp((unsigned char *)signature, (png_size_t)0, 4);
}


void user_read_fn(png_structp png_ptr, png_bytep data, png_size_t length) {
	unsigned char **read_io_ptr = (unsigned char **)png_get_io_ptr(png_ptr);
	memcpy(data, *read_io_ptr, length);
	*read_io_ptr += length;
}	


void CPngLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CBinaryData *binaryData = (CBinaryData *)imageData;
	binaryData->m_fileType = PNG;
	
	png_structp png_ptr;
	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,	NULL, NULL, NULL);
	if (png_ptr == NULL) {
		return;
	}
				
	png_set_read_fn(png_ptr, &data, user_read_fn); 
				
				
	png_infop info_ptr;
	unsigned int sig_read = 0;
	png_uint_32 width, height;
	int bit_depth, color_type, interlace_type;//, compression_type, filter_method;
	
	
	/* Allocate/initialize the memory for image information.  REQUIRED. */
	info_ptr = png_create_info_struct(png_ptr);
	if (info_ptr == NULL)
	{
		png_destroy_read_struct(&png_ptr, png_infopp_NULL, png_infopp_NULL);
		return;
	}
	
	/* Set error handling if you are using the setjmp/longjmp method (this is
	* the normal method of doing things with libpng).  REQUIRED unless you
	* set up your own error handlers in the png_create_read_struct() earlier.
	*/
	if (setjmp(png_jmpbuf(png_ptr)))
	{
		/* Free all of the memory associated with the png_ptr and info_ptr */
		png_destroy_read_struct(&png_ptr, &info_ptr, png_infopp_NULL);
		//			fclose(fp);
		/* If we get here, we had a problem reading the file */
		return;
	}
	
	
	/* If we have already read some of the signature */
	png_set_sig_bytes(png_ptr, sig_read);
	
	/*
	* If you have enough memory to read in the entire image at once,
	* and you need to specify only transforms that can be controlled
	* with one of the PNG_TRANSFORM_* bits (this presently excludes
	* dithering, filling, setting background, and doing gamma
	* adjustment), then you can read the entire image (including
	* pixels) into the info structure with this call:
	*/
	
	//my code
	png_read_info(png_ptr, info_ptr);
	png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
		&interlace_type, int_p_NULL, int_p_NULL);
	
	/* tell libpng to strip 16 bit/color files down to 8 bits/color */
	png_set_strip_16(png_ptr);
	
	/* Strip alpha bytes from the input data without combining with the
	* background (not recommended).
	*/
	//png_set_strip_alpha(png_ptr);
	
	/* Extract multiple pixels with bit depths of 1, 2, and 4 from a single
	* byte into separate bytes (useful for paletted and grayscale images).
	*/
	png_set_packing(png_ptr);
	
	/* Change the order of packed pixels to least significant bit first
	* (not useful if you are using png_set_packing). */
	//png_set_packswap(png_ptr);
	
	/* Expand paletted colors into true RGB triplets */
	if (color_type == PNG_COLOR_TYPE_PALETTE)
		png_set_palette_to_rgb(png_ptr);
	
	/* Expand grayscale images to the full 8 bits from 1, 2, or 4 bits/pixel */
	if (color_type == PNG_COLOR_TYPE_GRAY && bit_depth < 8)
		png_set_gray_1_2_4_to_8(png_ptr);
	
		/* Expand paletted or RGB images with transparency to full alpha channels
		* so the data will be available as RGBA quartets.
	*/
	if (png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS))
		png_set_tRNS_to_alpha(png_ptr);
	
	/* flip the RGB pixels to BGR (or RGBA to BGRA) */
	if (color_type & PNG_COLOR_MASK_COLOR)
		png_set_bgr(png_ptr);
	
	/* Add filler (or alpha) byte (before/after each RGB triplet) */
	png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);
	
	/* Optional call to gamma correct and add the background to the palette
	* and update info structure.  REQUIRED if you are expecting libpng to
	* update the palette for you (ie you selected such a transform above).
	*/
	png_read_update_info(png_ptr, info_ptr);
	
	/* Allocate the memory to hold the image using the fields of info_ptr. */
	
	/* The easiest way to read the image: */
	png_bytep *row_pointers = (png_bytep *)malloc(height*sizeof(png_bytep));
	for (unsigned int row = 0; row < height; row++) {
		row_pointers[row] = (unsigned char *)png_malloc(png_ptr, png_get_rowbytes(png_ptr, info_ptr));
	}
	
	/* Now it's time to read the image.  One of these methods is REQUIRED */
	png_read_image(png_ptr, row_pointers);
	png_read_end(png_ptr, info_ptr);
	
	unsigned char *dst = new unsigned char[4*width*height];	
	for (unsigned int i=0; i<height; i++) {
		memcpy(dst+i*width*4, row_pointers[height-1-i], width*4);
	}
	
	binaryData->m_width  = width;
	binaryData->m_height = height;

	BITMAPINFO bi;
	bi.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biPlanes		= 1;
	bi.bmiHeader.biBitCount		= 32;
	bi.bmiHeader.biCompression	= BI_RGB;
	bi.bmiHeader.biSizeImage	= 0;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biClrUsed		= 0;
	bi.bmiHeader.biClrImportant	= 0;
	bi.bmiHeader.biWidth		= binaryData->m_width;
	bi.bmiHeader.biHeight		= binaryData->m_height;

	CDC dc;
	dc.CreateCompatibleDC(NULL); 
	binaryData->m_bitmap = new CBitmap();
	binaryData->m_bitmap->CreateBitmap(binaryData->m_width, binaryData->m_height, dc.GetDeviceCaps(PLANES), dc.GetDeviceCaps(BITSPIXEL), NULL);
	::SetDIBits(dc.GetSafeHdc(), *binaryData->m_bitmap, 0, binaryData->m_height, dst, &bi, DIB_RGB_COLORS);
	
	delete [] dst;	
	//end my code
	
	for (row = 0; row < height; row++) {
		png_free(png_ptr, row_pointers[row]);
	}
	free(row_pointers);
	
	/* clean up after the read, and free any memory allocated - REQUIRED */
	png_destroy_read_struct(&png_ptr, &info_ptr, png_infopp_NULL);
}


