// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__20D12F8F_6CC6_4E41_9182_4F28173DE7B5__INCLUDED_)
#define AFX_MAINFRM_H__20D12F8F_6CC6_4E41_9182_4F28173DE7B5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "acidviewview.h"
#include "saucedlg.h"
#include "jumptodirectory.h"
#include "SaveAsAvi.h"
#include "CompressedFileFind.h"
#include "SortStringArray.h"

class CLeftView;
#define WM_SETMESSAGESTRING 0x0362

struct SlideShowSettings {
	bool	bRandom, bCycle, bSubdirectories, bCompressedFiles, bUseTextFile, bStartFullscreen;
	CString directory;
	CString textFile;
	int		delay;
};



class CMainFrame : public CFrameWnd
{

private:
	CSplitterWnd	m_wndSplitter;
	CMenu			m_oldMenu;

	bool				m_enableSlideShow;
	int					m_currentImage, m_lastImage;

	
	void	openNextFile();

protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)


public:
	void	stopSlideShow();
	void		setResolution(ViewResolution);
	void		SetSpeed(int);
	virtual		~CMainFrame();
	CAcidViewView*	GetRightPane();
	CLeftView*	GetLeftPane();
//	int			JumpToDir(CString, BOOL setSel=TRUE);
	BOOL		SetSelPath( LPCTSTR strPath );
	void		SetResolution(ViewResolution v);
	void		imageDone();

	//Need to be public for the command line slideshow start.. dirty hack i know
	SlideShowSettings	m_slideShow;	
	static		std::deque<CString> m_fileArray;
	static		void loadFileList(CString, CString, BOOL);
	void		startSlideShowImp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL DestroyWindow();
	protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL

// Implementation
public:
		afx_msg void OnViewFullscreen();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnFileOpennext();
	afx_msg void OnFileOpenprevious();
	afx_msg void OnSpeed14400();
	afx_msg void OnSpeed2400();
	afx_msg void OnSpeed28800();
	afx_msg void OnSpeed4800();
	afx_msg void OnSpeed9600();
	afx_msg void OnViewDecreaseresolution();
	afx_msg void OnViewIncreaseresolution();
	afx_msg void OnViewSauce();
	afx_msg void OnViewSize160p();
	afx_msg void OnViewSize320p();
	afx_msg void OnViewSize80p();
	afx_msg void OnViewSizeNormal();
	afx_msg void OnViewSmoothscroll();
	afx_msg void OnUpdateViewSmoothscroll(CCmdUI* pCmdUI);
	afx_msg void OnFileJumptodir();
	afx_msg void OnFileSetfilemask();
	afx_msg void OnSpeed57600();
	afx_msg void OnSpeed38400();
	afx_msg void OnUpdateViewSizeNormal(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSauce(CCmdUI* pCmdUI);
	afx_msg void OnFileRefresh();
	afx_msg void OnUpdateSpeed2400(CCmdUI* pCmdUI);
	afx_msg void OnFileRefreshwithmodem();
	afx_msg void OnUpdateSpeedAlwayson(CCmdUI* pCmdUI);
	afx_msg void OnSpeedAlwayson();
	afx_msg void OnView25lines();
	afx_msg void OnUpdateView25lines(CCmdUI* pCmdUI);
	afx_msg void OnView50lines();
	afx_msg void OnViewAcidview();
	afx_msg void OnViewAmiga();
	afx_msg void OnEnableRip();
	afx_msg void OnViewProps();
	afx_msg void OnHelpQuickhelp();
	afx_msg void OnToggleLineMode();
	afx_msg void OnToggleSpeed();
	afx_msg void OnFileGoback();
	afx_msg void OnFileGoforward();
	afx_msg void OnFileSaveasavi();
	afx_msg void OnUpdateFileSaveasavi(CCmdUI* pCmdUI);
	afx_msg void OnFileSaveaspng();
	afx_msg void OnViewPaletteBlackandwhite();
	afx_msg void OnViewPaletteIcecolors();
	afx_msg void OnUpdateViewPaletteIcecolors(CCmdUI* pCmdUI);
	afx_msg void OnViewPaletteLoadfromxb();
	afx_msg void OnViewPaletteNormal();
	afx_msg void OnViewPaletteLoaded();
	afx_msg void OnViewFontLoaded();
	afx_msg void OnUpdateViewPaletteNormal(CCmdUI* pCmdUI);
	afx_msg void OnViewFontLoadfromxb();
	afx_msg void OnViewPaletteAscii();
	afx_msg void OnViewPreferences();
	afx_msg void OnViewStartslideshow();
	afx_msg void OnUpdateViewStartslideshow(CCmdUI* pCmdUI);
	afx_msg void OnView9thColumn();
	//}}AFX_MSG

	afx_msg void OnUpdateViewStyles(CCmdUI* pCmdUI);
	afx_msg void OnViewStyle(UINT nCommandID);
	afx_msg LRESULT OnImageDone(WPARAM wParam, LPARAM lParam);
	LRESULT OnSetMessageString (WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__20D12F8F_6CC6_4E41_9182_4F28173DE7B5__INCLUDED_)
