#pragma once


#include "ImageRenderer.h"
#include "ImageContext.h"
#include "ImageData.h"


class CImageLoader {


protected:

	static __int64			m_frequency;
	CImageRenderer			*m_renderer;

	virtual void loadFileFromDataImp(const char *, const int, CImageData *) = 0;	
public:

	CImageLoader(CImageRenderer *);
	virtual ~CImageLoader();

	static	void baudSimWait(CImageContext *, CImageData *);
	Sauce *loadSauce(FILE *);
	Sauce *loadSauceFromData(const char *, const int length);
	CImageRenderer *getRenderer();

	/*! returns true if the file can be loaded by this loader class */
	virtual bool isFileType(const char *, const char *) = 0;	
	/*! start an animated load, called from the CView::InitialUpdate */
	virtual void startLoad(CImageContext *, CImageData *) = 0;

	virtual CImageData *loadFile(const char *) = 0;
	virtual CImageData *loadFileFromData(const char *, const int) = 0;	

	/*! used in avi rendering, returns true when done */
	virtual bool loadFrame(CImageContext *, CImageData *);
};