#pragma once


#include "ansifont.h"
#include "StdAfx.h"


enum ViewResolution {
	rNormal		= 0,
	r320		= 1,
	r160		= 2,
	r80			= 3
};

enum FontType {

	DOS_FONT			= 0,
	DOS_8X8_FONT		= 1,
	AMIGA_FONT			= 2,
	ACIDVIEW_FONT		= 3,
	LOADED_FONT			= 4
};

enum PaletteType {

	DOS_PALETTE			= 0,
	GRAYSCALE_PALETTE	= 1,
	ASCII_PALETTE	    = 2,
	LOADED_PALETTE      = 3
};

enum AnimationType {
	OFF,
	DEPENDENT,
	ON
};


class CAcidImage;
class CWinApp;
class CDC;

class CImageContext {

private:
	static bool			m_staticLoaded;

public:
	static int			m_numResolutions;
	static int			m_numFonts;
	static int			m_numPalettes;
	static CAnsiFont	*m_fonts[5];
	static ANSIPalette  *m_palettes[4];
	//pointer to the current font
	CAnsiFont			*m_font;
	//pointer to the current palettte
	ANSIPalette			*m_palette;

	//modem baud rate 
	int				m_speed;
	AnimationType	m_animation;
	//if true then recording a movie
	bool			m_recordMovie;
	//movie fps
	int				m_fps;
	//if true then render rips graphics
	bool			m_enableRip;
	//if true then the blink is on
	bool			m_blink;
	//scaling used
	ViewResolution	m_resolution;	
	//number of columns wide the bins should be displayed
	int				m_binWidth;	
	bool			m_iceColors;

	//If doing a slide show, you want to squeeze the binary images to fit the screen
	int				m_scaleWidth;

	//Amount to scale the binary images
	/*! \todo code */
	float			m_binaryScaleX;
	float			m_binaryScaleY;

	//If true, then extend text characters 1 column 
	/*! \todo code */
	bool			m_9thPixel;

	CDC				*m_pDC;
	int				m_savedDC;
	HWND			m_hWnd;


	//set the initial vals and get them from the registry
	CImageContext();
	~CImageContext();

	void setFont(FontType);
	void setPalette(PaletteType);
	void setResolution(ViewResolution);
	void loadRegistryValues(CWinApp *);
	void setRegistryValues(CWinApp *);
	bool isAnimation(CAcidImage *);

	void	loadPalette(const char *);
	void	loadFont(const char *);
	bool	isAscii();

	//Delete all the fonts and palettes
	static void staticShutdown();
	
};