// FileExtDlg.cpp : implementation file
//

#include "stdafx.h"
#include "acidview.h"
#include "FileExtDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileExtDlg dialog


CFileExtDlg::CFileExtDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFileExtDlg::IDD, pParent),
	m_numExtensions(5)
{
	//{{AFX_DATA_INIT(CFileExtDlg)
	//}}AFX_DATA_INIT
}

void CFileExtDlg::loadRegistryValues(CWinApp *pApp) {

	CString key;
	for (int i=0; i<m_numExtensions; i++) {
		key.Format("Mask%d", i+1);
		m_extensions[i] = pApp->GetProfileString(_T("Recent Mask List"), key, "*.*");
	}
}

void CFileExtDlg::setRegistryValues(CWinApp *pApp) {

	CString key;
	for (int i=0; i<m_numExtensions; i++) {
		key.Format("Mask%d", i+1);
		pApp->WriteProfileString(_T("Recent Mask List"), key, m_extensions[i]);
	}
}

void CFileExtDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileExtDlg)
	DDX_Control(pDX, IDC_COMBO1, m_combo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileExtDlg, CDialog)
	//{{AFX_MSG_MAP(CFileExtDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileExtDlg message handlers

int CFileExtDlg::DoModal() 
{
	
	//loadRegistryValues(AfxGetApp());
	return CDialog::DoModal();
}

BOOL CFileExtDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	for (int i=0; i<m_numExtensions; i++) {
		if (m_extensions[i]!="*.*")
			m_combo.AddString(m_extensions[i]);
	}

	CString textExt  = "*.ans;*.adf;*.asc;*.bin;*.xb;*.nfo;*.diz;*.mem;*.rip";
	CString hirezExt = "*.gif;*.jpg;*.png"; 

	m_combo.AddString(textExt);
	m_combo.AddString(hirezExt);
	m_combo.AddString(textExt+";"+hirezExt);
	m_combo.SetWindowText(m_mask);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileExtDlg::OnOK() {
	m_combo.GetWindowText(m_mask);	
	if (m_mask.GetLength()==0) {
		m_mask = "*.*";
	}
	CDialog::OnOK();
}
